package com.liquidnet.service.galaxy.router.zxin.biz;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.constant.ZxlErrorEnum;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftEnum;
import com.liquidnet.common.third.zxlnft.dto.*;
import com.liquidnet.common.third.zxlnft.dto.wallet.UploadToCosReq;
import com.liquidnet.common.third.zxlnft.dto.wallet.UploadToCosResp;
import com.liquidnet.common.third.zxlnft.exception.ZxlNftException;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesInfoBo;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.biz.GalaxyCommonBiz;
import com.liquidnet.service.galaxy.router.strategy.biz.GalaxyEnumBiz;
import com.liquidnet.service.galaxy.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.math.BigDecimal;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxinArtworkBiz
 * @Package com.liquidnet.service.galaxy.router.zxin.biz
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 13:04
 */
@Slf4j
@Component
public class ZxinArtworkBiz {
    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    @Autowired
    private ZxlnftConfig zxlnftConfig;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private GalaxyCommonBiz galaxyCommonBiz;

    public ResponseDto<GalaxyNftImageRespDto> nftImageCheck(GalaxyNftImageReqDto reqDto) {
        Nft008QueryImageModerationReqDto nft008ReqDto = Nft008QueryImageModerationReqDto.getNew();
        nft008ReqDto.setImageUrl(reqDto.getNftOriginalUrl());
        ZxlnftResponseDto<Nft008QueryImageModerationRespDto> nft008RespDto = zxlnftSdkUtil.nft008QueryImageModeration(nft008ReqDto);
        if(!nft008RespDto.isSuccess()){
            throw new ZxlNftException(ZxlErrorEnum.IMAGE_CHECK_ERROR.getCode(),ZxlErrorEnum.IMAGE_CHECK_ERROR.getMsg());
        }
        GalaxyNftImageRespDto nftImageRespDto = GalaxyNftImageRespDto.getNew();
        BeanUtil.copy(nft008RespDto.getData(),nftImageRespDto);
        return ResponseDto.success(nftImageRespDto);
    }



    public ResponseDto<GalaxyNftUploadRespDto> nftUpload(GalaxyNftUploadReqDto reqDto) {
        /**
         * 系列缓存初始化
         */
        //获取任务ID
        GalaxySeriesInfoBo seriesInfoBo = dataUtils.getSeriesInfoBo(reqDto.getRouterType(),reqDto.getSkuId());
        if(StringUtil.isNotNull(seriesInfoBo)){
            return ResponseDto.failure("素材已经上传过！");
        }

        String originalNftUrl = reqDto.getOriginalNftUrl();
        String originalDisplayUrl = reqDto.getOriginalDisplayUrl();
        //上传系列名只用来目录区分
        String seriesName = GalaxyConstant.SERIES_NAME_PREFIX + reqDto.getSkuId(); //素材存储目录

        //返回素材上传结果
        GalaxyNftUploadRespDto galaxyNftUploadRespDto = GalaxyNftUploadRespDto.getNew();
        galaxyNftUploadRespDto.setSkuId(reqDto.getSkuId());
        galaxyNftUploadRespDto.setNftUrl(this.getFullFilePath(seriesName,originalNftUrl));
        galaxyNftUploadRespDto.setOriginalNftUrl(reqDto.getOriginalNftUrl());
        galaxyNftUploadRespDto.setDisplayUrl(this.getFullFilePath(seriesName,originalDisplayUrl));
        galaxyNftUploadRespDto.setOriginalDisplayUrl(reqDto.getOriginalDisplayUrl());


        seriesInfoBo = this.buildSeriesInfoBo(false,reqDto.getSkuId(),seriesName,null,null,0l
                ,originalNftUrl,originalDisplayUrl,null,GalaxyEnum.SeriesClaimStatusEnum.SERIES_INIT.getCode()
                ,null,null,null,null,null,null,null,null,null);

        dataUtils.setSeriesInfoBo(reqDto.getRouterType(),reqDto.getSkuId(),seriesInfoBo);

        return ResponseDto.success(galaxyNftUploadRespDto);

//        1.4.4调用查询素材地址接口 -- 非必需
//        Nft021UploadUrlReqDto nft021ReqDto = Nft021UploadUrlReqDto.getNew();
//        nft021ReqDto.setSeriesName(seriesName);
//        nft021ReqDto.setPlatformIdentification(zxlnftConfig.getPlatformIdentification());
//        //如果上传人就是平台管理员，以下需要注释掉，因为会导致返回的地址多了一级目录
////        nft021ReqDto.setUserIdentification(zxlnftConfig.getPlatformIdentification());
//        ZxlnftResponseDto<Nft021UploadUrlRespDto> resp = zxlnftSdkUtil.nft021UploadUrl(nft021ReqDto);
    }

    public ResponseDto<GalaxyArtSeriesClaimRespDto> seriesClaim(GalaxyArtSeriesClaimReqDto reqDto) {
        //系列声明用到参数
        String skuId = reqDto.getSkuId();
        String seriesName = GalaxyConstant.SERIES_NAME_PREFIX.concat(skuId);
        Long totalCount = reqDto.getTotalCount();
        String coverUrl = reqDto.getCoverUrl();//暂时用nftUrl
        String seriesDesc = reqDto.getSeriesDesc();
        //发行用到的相关信息
        String author = reqDto.getAuthor();
        String nftName = reqDto.getNftName();
        String nftUrl = reqDto.getNftUrl();
        String displayUrl = reqDto.getDisplayUrl();
        String nftDesc = reqDto.getNftDesc();
        String nftFlag = reqDto.getNftFlag();
        String sellCount = reqDto.getSellCount();

        GalaxySeriesInfoBo seriesInfoBo = dataUtils.getSeriesInfoBo(reqDto.getRouterType(),reqDto.getSkuId());
        if(StringUtil.isNotNull(seriesInfoBo)){
            /**
             * 如果系列声明成功，则不允许继续声明
             */
            if(seriesInfoBo.getSeriesClaimStatus().equalsIgnoreCase(GalaxyEnum.SeriesClaimStatusEnum.PROCESSING.getCode())){
                return ResponseDto.failure(GalaxyErrorEnum.SERIES_CLAIM_PROCESSING.getCode(),GalaxyErrorEnum.SERIES_CLAIM_PROCESSING.getMessage());
            }else if(seriesInfoBo.getSeriesClaimStatus().equalsIgnoreCase(GalaxyEnum.SeriesClaimStatusEnum.SUCCESS.getCode())){
                return ResponseDto.failure(GalaxyErrorEnum.SERIES_CLAIM_SUCCESSED.getCode(),GalaxyErrorEnum.SERIES_CLAIM_SUCCESSED.getMessage());
            }
        }else{
            return ResponseDto.failure(GalaxyErrorEnum.SERIES_CLAIM_NOT_EXIST.getCode(),GalaxyErrorEnum.SERIES_CLAIM_NOT_EXIST.getMessage());
        }
        /**
         * 进行系列声明
         */
        Nft030SeriesClaimReqDto nft030ReqDto = Nft030SeriesClaimReqDto.getNew();
        nft030ReqDto.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        nft030ReqDto.setSeriesName(seriesName);
        //无限制系列 设置为0
        nft030ReqDto.setTotalCount(totalCount);
        nft030ReqDto.setOperateId(IDGenerator.get32UUID());
        //系列封面
        nft030ReqDto.setCoverUrl(coverUrl);
        nft030ReqDto.setDesc(seriesDesc);
        nft030ReqDto.setMaxPublishCount(0);
        nft030ReqDto.setSeriesBeginFromZero(false);
        ZxlnftResponseDto<Nft030SeriesClaimRespDto> nft30RespDto = zxlnftSdkUtil.nft030SeriesClaim(nft030ReqDto);

        //返回参数
        String seriesId = null;
        String taskId = null;
        if(nft30RespDto.isSuccess()){
            //第零个系列 无限制系列
            taskId = nft30RespDto.getData().getTaskId();
        }

        GalaxyArtSeriesClaimRespDto seriesClaimRespDto = GalaxyArtSeriesClaimRespDto.getNew();
        seriesClaimRespDto.setSkuId(skuId);
        seriesClaimRespDto.setNftUrl(nftUrl);
        seriesClaimRespDto.setDisplayUrl(displayUrl);
        seriesClaimRespDto.setSeriesId(seriesId);
        seriesClaimRespDto.setSeriesName(seriesName);

        //构造缓存数据
        if(StringUtil.isNotNull(seriesInfoBo)){
            //
            String publishStatus = GalaxyEnum.SeriesClaimStatusEnum.PROCESSING.getCode();
            //设置系列声明状态
            seriesClaimRespDto.setSeriesClaimStatus(publishStatus);

            seriesInfoBo = this.buildSeriesInfoBo(false,skuId,seriesName,seriesId,totalCount,0l
                    ,seriesInfoBo.getOriginalNftUrl(),seriesInfoBo.getOriginalDisplayUrl(),taskId,publishStatus
                    ,author,nftName,nftUrl,displayUrl,nftDesc,nftFlag,sellCount,coverUrl,seriesDesc);
            dataUtils.setSeriesInfoBo(reqDto.getRouterType(),reqDto.getSkuId(),seriesInfoBo);
        }

        return ResponseDto.success(seriesClaimRespDto);
    }


    public ResponseDto<GalaxyArtSeriesClaimRespDto> seriesClaimBackup(GalaxyArtSeriesClaimReqDto reqDto) {
        //系列声明用到参数
        String skuId = reqDto.getSkuId();
        String seriesName = GalaxyConstant.SERIES_NAME_PREFIX.concat(skuId);
        Long totalCount = reqDto.getTotalCount();
        String coverUrl = reqDto.getCoverUrl();//暂时用nftUrl
        String seriesDesc = reqDto.getSeriesDesc();
        //发行用到的相关信息
        String author = reqDto.getAuthor();
        String nftName = reqDto.getNftName();
        String nftUrl = reqDto.getNftUrl();
        String displayUrl = reqDto.getDisplayUrl();
        String nftDesc = reqDto.getNftDesc();
        String nftFlag = reqDto.getNftFlag();
        String sellCount = reqDto.getSellCount();


        //返回参数
        String seriesId = null;
        String taskId = null;
        GalaxySeriesInfoBo seriesInfoBo = dataUtils.getSeriesInfoBo(reqDto.getRouterType(),reqDto.getSkuId());
        if(StringUtil.isNotNull(seriesInfoBo)){
            /**
             * 如果系列声明成功，则不允许继续声明
             */
            if(seriesInfoBo.getSeriesClaimStatus().equalsIgnoreCase(GalaxyEnum.SeriesClaimStatusEnum.SUCCESS.getCode())){
                GalaxyArtSeriesClaimRespDto seriesClaimRespDto = GalaxyArtSeriesClaimRespDto.getNew();
                seriesClaimRespDto.setSkuId(seriesInfoBo.getSkuId());
                seriesClaimRespDto.setNftUrl(seriesInfoBo.getNftUrl());
                seriesClaimRespDto.setSeriesId(seriesInfoBo.getSeriesId());
                seriesClaimRespDto.setSeriesName(seriesInfoBo.getSeriesName());
                return ResponseDto.success(seriesClaimRespDto);
            }
        }
        /**
         * 进行系列声明
         */
        Nft030SeriesClaimReqDto nft030ReqDto = Nft030SeriesClaimReqDto.getNew();
        nft030ReqDto.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        nft030ReqDto.setSeriesName(seriesName);
        //无限制系列 设置为0
        nft030ReqDto.setTotalCount(totalCount);
        nft030ReqDto.setOperateId(IDGenerator.get32UUID());
        //系列封面
        nft030ReqDto.setCoverUrl(coverUrl);
        nft030ReqDto.setDesc(seriesDesc);
        nft030ReqDto.setMaxPublishCount(0);
        nft030ReqDto.setSeriesBeginFromZero(false);
        ZxlnftResponseDto<Nft030SeriesClaimRespDto> nft30RespDto = zxlnftSdkUtil.nft030SeriesClaim(nft030ReqDto);

        //{"taskId":"49d1cccc-e62c-40bc-923c-bfac31325351_nft-series-claim_1"}
        if(nft30RespDto.isSuccess()){
            //系列声明结果查询
            Nft031SeriesClaimResultReqDto nft031ReqDto = Nft031SeriesClaimResultReqDto.getNew();
            //第零个系列 无限制系列
            taskId = nft30RespDto.getData().getTaskId();
            nft031ReqDto.setTaskId(taskId);

            int count  = 0;
            while(StringUtil.isEmpty(seriesId)){
                //休眠1秒钟，等待执行结果
                try {
                    Thread.sleep(1000l);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }

                count++;
                log.info("=======执行第{}次查询,taskId:{}",count,nft031ReqDto.getTaskId());
                ZxlnftResponseDto<Nft031SeriesClaimResultRespDto> nft031RespDtoTemp = zxlnftSdkUtil.nft031SeriesClaimResult(nft031ReqDto);
                if(nft031RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                    seriesId = nft031RespDtoTemp.getData().getSeriesId();
                    break;
                }else if(nft031RespDtoTemp.getData().getTaskStatus().toString().equals(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                    log.info("任务执行失败！taskId:{}",nft031ReqDto.getTaskId());
                    return ResponseDto.failure(GalaxyErrorEnum.SERIES_CLAIM_ERROR.getCode(), GalaxyErrorEnum.SERIES_CLAIM_ERROR.getMessage());
                }
                if(count==5){
                    log.info("=======查询共5次，跳出循环！taskId:{}",nft031ReqDto.getTaskId());
                    return ResponseDto.failure(GalaxyErrorEnum.SERIES_CLAIM_ERROR_FIVE_TIMES.getCode(), GalaxyErrorEnum.SERIES_CLAIM_ERROR_FIVE_TIMES.getMessage());
                }
            }

            log.info("系列声明结果查询 seriesId :{}",seriesId);
        }

        GalaxyArtSeriesClaimRespDto seriesClaimRespDto = GalaxyArtSeriesClaimRespDto.getNew();
        seriesClaimRespDto.setSkuId(skuId);
        seriesClaimRespDto.setNftUrl(nftUrl);
        seriesClaimRespDto.setSeriesId(seriesId);
        seriesClaimRespDto.setSeriesName(seriesName);

        //构造缓存数据
        if(seriesInfoBo==null){
            //设置为处理中
            String publishStatus = GalaxyEnum.SeriesClaimStatusEnum.PROCESSING.getCode();
            seriesInfoBo = this.buildSeriesInfoBo(false,skuId,seriesName,seriesId,totalCount,0l
                    ,null,null,null,publishStatus
                    ,author,nftName,nftUrl,displayUrl,nftDesc,nftFlag,sellCount,coverUrl,seriesDesc);
            dataUtils.setSeriesInfoBo(reqDto.getRouterType(),reqDto.getSkuId(),seriesInfoBo);
        }
        return ResponseDto.success(seriesClaimRespDto);
    }

    public ResponseDto<GalaxyArtSeriesClaimResultQueryRespDto> seriesClaimResultQuery(GalaxyArtSeriesClaimResultQueryReqDto reqDto) {
        //获取任务ID
        GalaxySeriesInfoBo seriesInfoBo = dataUtils.getSeriesInfoBo(reqDto.getRouterType(),reqDto.getSkuId());
        if(StringUtil.isNull(seriesInfoBo)||StringUtil.isEmpty(seriesInfoBo.getSeriesClaimTaskId())){
            return ResponseDto.failure(GalaxyErrorEnum.SERIES_NOT_EXIST.getCode(), GalaxyErrorEnum.SERIES_NOT_EXIST.getMessage());
        }

        //查询NFT系列声明结果
        Nft031SeriesClaimResultReqDto nft031SeriesClaimResultReqDto = Nft031SeriesClaimResultReqDto.getNew();
        nft031SeriesClaimResultReqDto.setTaskId(seriesInfoBo.getSeriesClaimTaskId());
        nft031SeriesClaimResultReqDto.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());
        ZxlnftResponseDto<Nft031SeriesClaimResultRespDto> resp = zxlnftSdkUtil.nft031SeriesClaimResult(nft031SeriesClaimResultReqDto);
        if(resp.isSuccess()){
            GalaxyArtSeriesClaimResultQueryRespDto resultQueryRespDto = GalaxyArtSeriesClaimResultQueryRespDto.getNew();
            BeanUtil.copy(resp.getData(),resultQueryRespDto);
            resultQueryRespDto.setTaskStatus(Integer.valueOf(GalaxyEnumBiz.getTaskStatusEnum(reqDto.getRouterType(),resp.getData().getTaskStatus().toString()).getCode()));
            return ResponseDto.success(resultQueryRespDto);
        }else{
            return ResponseDto.failure(GalaxyErrorEnum.SERIES_CLAIM_ERROR.getCode(), GalaxyErrorEnum.SERIES_CLAIM_ERROR.getMessage());
        }
    }

    private String getFullFilePath(String seriesName,String originalUrl){
        String filePath = null;
        String imageType = null;

        if(originalUrl.lastIndexOf("?")!=-1){
            String tempUrl = originalUrl.substring(0,originalUrl.lastIndexOf("?"));
            imageType = tempUrl.substring(tempUrl.lastIndexOf("."),tempUrl.length());
        }else{
            imageType = originalUrl.substring(originalUrl.lastIndexOf("."),originalUrl.length());
        }
        String fileName =  IDGenerator.getZxlNftImageCosCode() + imageType;

        //通过图片url地址上传
        File cosFile = galaxyCommonBiz.inputStreamToFile(originalUrl,fileName);
        filePath = cosFile.getAbsolutePath();
        log.info("cosFile.getPath() :{}",cosFile.getPath());
        log.info("cosFile.getAbsoluteFile() :{}",cosFile.getAbsoluteFile());

        //完整全路径 https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/NOW_ZXL_NFT_PIC001_test_skuId001/2022-03-04/ZXLNFTIMAGE202203041707466694345291.jpg
        String fullFilePath = null; //需要保存,返回给调用者

//        1.4.2调用生成素材上传临时密钥接口
        Nft022UploadSecretReqDto nft022ReqDto = Nft022UploadSecretReqDto.getNew();
        nft022ReqDto.setSeriesName(seriesName);
        nft022ReqDto.setTimestamp(DateUtil.getNowSeconds().toString());
        nft022ReqDto.setUserPubKey(zxlnftConfig.getNftPlatformPubKey());

        //系列为空
        String userData = nft022ReqDto.getTimestamp();
        //系列不为空
        if(StringUtil.isNotEmpty(nft022ReqDto.getSeriesName())){
            userData = nft022ReqDto.getTimestamp() + "_" + nft022ReqDto.getSeriesName();
        }

        nft022ReqDto.setUserSignedData(zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),userData));

        ZxlnftResponseDto<Nft022UploadSecretRespDto> nft022RespDto = zxlnftSdkUtil.nft022UploadSecret(nft022ReqDto);

        if(!nft022RespDto.isSuccess()){
            throw new ZxlNftException(ZxlErrorEnum.UPLOAD_TEMP_SECRET.getCode(),ZxlErrorEnum.UPLOAD_TEMP_SECRET.getMsg());
        }
//        1.4.3调用sdk接口-上传cos接口
        if(nft022RespDto.isSuccess()){
            fullFilePath = nft022RespDto.getData().getUploadAddress().concat(fileName);
            UploadToCosReq req = UploadToCosReq.getNew();
            req.setCosPath(fullFilePath);
            req.setTempSecretId(nft022RespDto.getData().getTempSecretId());
            req.setTempSecretKey(nft022RespDto.getData().getTempSecretKey());
            req.setSessionToken(nft022RespDto.getData().getSessionToken());
            req.setFilePath(filePath);
            UploadToCosResp uploadToCosResp = zxlWalletSdkUtil.uploadToCos(req);
        }

        log.info("完整的素材访问fullFilePath url：{}",fullFilePath);
        return  fullFilePath;
    }


    private GalaxySeriesInfoBo buildSeriesInfoBo(
            boolean isInit,String skuId,String seriesName,String seriesId,Long totalCount,Long crtCount
            ,String originalNftUrl,String originalDisplayUrl,String seriesClaimTaskId,String seriesClaimStatus
            ,String author,String nftName,String nftUrl,String displayUrl,String nftDesc
            ,String nftFlag,String sellCount,String coverUrl,String seriesDesc){

        GalaxySeriesInfoBo seriesInfoBo = GalaxySeriesInfoBo.getNew();
        seriesInfoBo.setSkuId(skuId);
        seriesInfoBo.setSeriesName(seriesName);
        seriesInfoBo.setSeriesId(seriesId);
        seriesInfoBo.setTotalCount(totalCount);
        seriesInfoBo.setCrtCount(crtCount);
        seriesInfoBo.setOriginalNftUrl(originalNftUrl);
        seriesInfoBo.setOriginalDisplayUrl(originalDisplayUrl);
        seriesInfoBo.setSeriesClaimTaskId(seriesClaimTaskId);
        seriesInfoBo.setSeriesClaimStatus(seriesClaimStatus);
        //以下为购买信息
        seriesInfoBo.setAuthor(author);
        seriesInfoBo.setNftName(nftName);
        seriesInfoBo.setNftUrl(nftUrl);
        seriesInfoBo.setDisplayUrl(displayUrl);
        seriesInfoBo.setNftDesc(nftDesc);
        seriesInfoBo.setNftFlag(nftFlag);
        seriesInfoBo.setSellCount(sellCount==null?null:new BigDecimal(sellCount));
        seriesInfoBo.setCoverUrl(coverUrl);
        seriesInfoBo.setSeriesDesc(seriesDesc);
        return seriesInfoBo;
    }
}
