package com.liquidnet.service.consumer.sweet.config;

import com.liquidnet.service.consumer.sweet.receiver.ConsumerSweetAppletUserRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

import static com.liquidnet.service.base.constant.MQConst.SweetQueue.SWEET_APPLET_USER_INSERT;

@Configuration
public class ConsumerSweetAppletUserRedisStreamConfig {
    @Autowired
    ConsumerSweetAppletUserRdsReceiver consumerSweetAppletUserRdsReceiver;

    private StreamMessageListenerContainer<String, MapRecord<String, String, String>> buildStreamMessageListenerContainer(RedisConnectionFactory factory) {
        var options = StreamMessageListenerContainer
                .StreamMessageListenerContainerOptions
                .builder()
                .pollTimeout(Duration.ofMillis(1))
                .build();
        return StreamMessageListenerContainer.create(factory, options);
    }

    /**
     * 小程序登录记录用户解密后信息
     */
    private Subscription receiveSqlSweetAppletUser(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(
                Consumer.from(SWEET_APPLET_USER_INSERT.getGroup(), SWEET_APPLET_USER_INSERT.name() + t),
                StreamOffset.create(SWEET_APPLET_USER_INSERT.getKey(), ReadOffset.lastConsumed()), consumerSweetAppletUserRdsReceiver
        );
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    @Bean
    public Subscription subscriptionSqlSweetAppletUser(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlSweetAppletUser(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlSweetAppletUser2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlSweetAppletUser(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlSweetAppletUser3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlSweetAppletUser(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜  */
}
