package com.liquidnet.service.sweet.controller;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.SweetManualAppletDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistList2Dto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListDto;
import com.liquidnet.service.sweet.entity.SweetManualNotify;
import com.liquidnet.service.sweet.entity.SweetManualShop;
import com.liquidnet.service.sweet.entity.SweetRichtext;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.vo.SweetArtistsRelationVo;
import com.liquidnet.service.sweet.vo.SweetManualShopAllVo;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@Api(tags = "小程序")
@RestController
@RequestMapping("/sweet-applet")
public class SweetAppletController {

    @Autowired
    private RedisDataUtils redisDataUtils;

    @GetMapping("timeSelect")
    @ApiOperation("场次选择")
    public ResponseDto<List<SweetManualAppletDto>> timeSelect() {
        return ResponseDto.success(redisDataUtils.getPushList());
    }

    @GetMapping("details")
    @ApiOperation("详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
    })
    public ResponseDto<SweetManualAppletDto> details(@RequestParam() String manualId) {
        return ResponseDto.success(redisDataUtils.getAppletPerformance(manualId));
    }

    @GetMapping("notify")
    @ApiOperation("通知")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
    })
    public ResponseDto<List<SweetManualNotify>> notify(@RequestParam() String manualId) {
        return ResponseDto.success(redisDataUtils.getNotifyRedisData(manualId));
    }

    @GetMapping("tags")
    @ApiOperation("标签")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
    })
    public ResponseDto<List<String>> tag(@RequestParam() String manualId) {
        return ResponseDto.success(redisDataUtils.getTagRedisData(manualId));
    }

    @GetMapping("timeList")
    @ApiOperation("时间表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "dateTime", value = "时间 全部传 \"\"", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "stage", value = "舞台 全部传 \"\"", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isSign", value = "是否签名(1是0否)", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
    })
    public ResponseDto<SweetManualArtistList2Dto> timeList(@RequestParam() String manualId,
                                                           @RequestParam() String dateTime,
                                                           @RequestParam() String stage,
                                                           @RequestParam() Integer isSign,
                                                           @RequestParam() Integer page,
                                                           @RequestParam() Integer size) {
        String uid = CurrentUtil.getCurrentUid();
        int startPosition = (page - 1) * size;
        int endPosition = (page) * size;
        SweetManualArtistList2Dto data = redisDataUtils.getTimeList(manualId);
        SweetArtistsRelationVo relationData = redisDataUtils.getArtistsRelationRedisVo(uid);

        List<SweetManualArtistListDto> artistData = data.getData();
        List<SweetManualArtistListDto> allReturnArtist = new ArrayList();
        List<SweetManualArtistListDto> returnArtist = new ArrayList();
        for (SweetManualArtistListDto item : artistData) {
            boolean isSave = false;
            if (isSign == 1) {
                if (item.getSignatureStart() != null) {
                    //保留
                    isSave = true;
                }
            }

            if (!dateTime.isEmpty()) {
                if (item.getPerformanceStart().contains(dateTime)) {
                    //保留
                    isSave = true;
                }
            }

            if (!stage.isEmpty()) {
                if (item.getTitle().equalsIgnoreCase(stage)) {
                    //保留
                    isSave = true;
                }
            }

            if (isSave) {
                allReturnArtist.add(item);
            }
        }

        for (int i = 0; i < allReturnArtist.size(); i++) {
            SweetManualArtistListDto item = allReturnArtist.get(i);
            if (i >= startPosition && i < endPosition) {

                item.setIsWatch(0);
                item.setIsSign(0);

                for (String artistsId : relationData.getWatchList()) {
                    if (artistsId.equalsIgnoreCase(item.getArtistId())) {
                        item.setIsWatch(1);
                        break;
                    }
                }

                for (String artistsId : relationData.getSignList()) {
                    if (artistsId.equalsIgnoreCase(item.getArtistId())) {
                        item.setIsSign(1);
                        break;
                    }
                }

                returnArtist.add(item);
            }
        }

        data.setData(returnArtist);
        data.setTotal(allReturnArtist.size());
        return ResponseDto.success(data);
    }

    @GetMapping("richText")
    @ApiOperation("富文本")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "电子手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "type", value = "类型 (1签售时间 2现场地图 3官方大巴 4公共交通 5自驾导航坐标 6官方支持 7观众须知 8防疫指南 9观演攻略)", required = true),
    })
    public ResponseDto<SweetRichtext> richText(@RequestParam() String manualId,
                                               @RequestParam() String type) {
        return ResponseDto.success(redisDataUtils.getRichTextRedisData(manualId, type));
    }

    @PostMapping("artistsWatch")
    @ApiOperation("艺人-想看")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "uid", value = "用户id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistsId", value = "艺人id", required = true)
    })
    public ResponseDto<Boolean> watch(@RequestParam() String uid,
                                      @RequestParam() String artistsId) {
        redisDataUtils.setArtistsRelationRedisVo(uid, artistsId, "sign");
        return ResponseDto.success();
    }

    @PostMapping("artistsSign")
    @ApiOperation("艺人-签售")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "uid", value = "用户id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistsId", value = "艺人id", required = true)
    })
    public ResponseDto<Boolean> sign(@RequestParam() String uid,
                                     @RequestParam() String artistsId) {
        redisDataUtils.setArtistsRelationRedisVo(uid, artistsId, "watch");
        return ResponseDto.success();
    }

    @GetMapping("manualShop")
    @ApiOperation("吃喝玩乐")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "uid", value = "用户id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistsId", value = "艺人id", required = true)
    })
    public ResponseDto<SweetManualShopAllVo> manualShop(@RequestParam String manualId) {
        List<SweetManualShop> shopList = redisDataUtils.getManualShopRedisData(manualId);

        List<SweetManualShop> recommend = new ArrayList<>();
        List<SweetManualShop> eat = new ArrayList<>();
        List<SweetManualShop> play = new ArrayList<>();
        SweetManualShopAllVo vo = SweetManualShopAllVo.getNew();

        for (SweetManualShop item : shopList) {
            if(item.getIsRecommend().equals(1)){
                recommend.add(item);
            }
            if(item.getType().equals(1)){
                eat.add(item);
            }
            if(item.getType().equals(2)){
                play.add(item);
            }
        }

        vo.setRecommend(recommend);
        vo.setEat(eat);
        vo.setPlay(play);

        return ResponseDto.success(vo);
    }
}
