package com.liquidnet.commons.lang.constant;

public class LnsRegex {
    public static class Valid {
        /**
         * yyyy-MM-dd HH:mm:ss
         */
        public static final String DATETIME_FULL = "^(((((0[48]|[2468][048]|[3579][26])00))|(([0-9]{2})(0[48]|[2468][048]|[13579][26])))[-|.|/| ]0?2[-|.|/| ]29|(((?!0{1,4})[0-9]{1,4})[-|.|/| ](((0[13-9]|1[0-2]|[13-9])[-|.|/| ](29|30))|((0[13578]|(10|12)|[13578])[-|.|/| ]31)|((0(?:[1-9])|1(?:[0-2])|[1-9])[-|.|/| ](0(?:[1-9])|1[0-9]|2[0-8]|[1-9])))))( ((0?[0-9])|(1[0-9]|2[0-3])):(([1-5][0-9])|(0?[0-9])):(([1-5][0-9])|(0?[0-9])))?$";
        /**
         * yyyy-MM-dd
         */
        public static final String DATETIME_YMD = "^(((((0[48]|[2468][048]|[3579][26])00))|(([0-9]{2})(0[48]|[2468][048]|[13579][26])))[-|.|/| ]0?2[-|.|/| ]29|(((?!0{1,4})[0-9]{1,4})[-|.|/| ](((0[13-9]|1[0-2]|[13-9])[-|.|/| ](29|30))|((0[13578]|(10|12)|[13578])[-|.|/| ]31)|((0(?:[1-9])|1(?:[0-2])|[1-9])[-|.|/| ](0(?:[1-9])|1[0-9]|2[0-8]|[1-9])))))$";
        /**
         * 字母、数字组合
         */
        public static final String LETTER_NUMBER = "^[A-Z0-9]+$";
        /**
         * 汉字-姓名（2～20位）
         */
        public static final String CN_HANZI = "^[\\u4e00-\\u9fa5]{2,20}$";
        /**
         * 汉字-省|市|区（2～30位）
         */
        public static final String CN_PCD = "^[\\u4e00-\\u9fa5]{2,30}$";


        /* ======================================================================= | 证件类 */


        /**
         * 大陆居民身份证（15位||18位）
         */
        public static final String CN_ID_CARD = "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)";
        /**
         * 大陆居民身份证
         */
        public static final String CN_ID_CARD_REF = "(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}$)";
        /**
         * 军官证
         * 规则： 军/兵/士/文/职/广/（其他中文） + "字第" + 4到8位字母或数字 + "号"
         * 样本： 军字第2001988号, 士字第P011816X号
         */
        public static final String CN_ID_CARD_MO = "^[\\x{4E00}-\\x{9FA5}](字第)([0-9a-zA-Z]{4,8})(号?)$";
        /**
         * 中国大陆护照
         * 规则： 14/15开头 + 7位数字, P + 7位数字, G/E + 8位数字, S/D + 7或8位数字, 等
         * 样本： 141234567, G12345678, P1234567
         */
        public static final String CN_ID_CARD_PP = "^(?:P\\d{7}|[GE]\\d{8}|[SD]\\d{7,8}|[PSD]E\\d{7}|1[45]\\d{7})$";
        /**
         * 非中国大陆护照
         */
        public static final String CN_ID_CARD_PP_NON = "^([A-Z0-9]){5,17}$";
        /**
         * 港澳居民来往内地通行证
         * 规则： H/M + 8位数字, C + 8位数字, C + 1位字母除去IO + 7位数字
         * 样本： H12345678
         */
        public static final String CN_ID_CARD_HM = "^(?:[HM]\\d{8}|C[A-HJ-NP-Z0-9]\\d{7})$";
        /**
         * 台湾居民来往大陆通行证
         * 规则： 8位数字, 18位数字, 10位数字 + 1位英文字母
         * 样本： 12345678 1234567890B
         */
        public static final String CN_ID_CARD_TW = "^(?:\\d{8}|\\d{18}|\\d{10}[A-Z])$";


        /* ======================================================================= | 第三方平台类 */


        /**
         * 支持的第三方账号平台类型(用户中心:登录注册)
         */
        public static final String TRIPLE_PF_FOR_ULGOIN = "\\b(WEIBO|WECHAT|QQ)\\b";
        /**
         * 支持的支付终端
         */
        public static final String TRIPLE_PF_FOR_PAY_TERMINAL = "\\b(app|wap|js|applet)\\b";
        /**
         * 支持的支付方式
         */
        public static final String TRIPLE_PF_FOR_PAY = "\\b(alipay|wepay)\\b";


        /* ======================================================================= |  */





        /* ======================================================================= |  */





        /* ======================================================================= |  */
    }
}
