package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontMoudleIndexService;
import com.liquidnet.service.goblin.entity.GoblinFrontMoudleIndex;
import com.liquidnet.service.goblin.mapper.GoblinFrontMoudleIndexMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 组件排序 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-06
 */
@Service
public class GoblinFrontMoudleIndexServiceImpl extends ServiceImpl<GoblinFrontMoudleIndexMapper, GoblinFrontMoudleIndex> implements IGoblinFrontMoudleIndexService {
    @Autowired
    GoblinFrontMoudleIndexMapper goblinFrontMoudleIndexMapper;

    @Override
    public List<GoblinFrontMoudleIndex> listGoblinFrontMoudleIndex() {
        LambdaQueryWrapper<GoblinFrontMoudleIndex> queryWrapper = Wrappers.lambdaQuery(GoblinFrontMoudleIndex.class);
        queryWrapper.orderByAsc(GoblinFrontMoudleIndex::getIndexs);
        List<GoblinFrontMoudleIndex> list=goblinFrontMoudleIndexMapper.selectList(queryWrapper);
        return list;
    }

    @Override
    public boolean upadteGoblinFrontMoudleIndex(GoblinFrontMoudleIndex goblinFrontMoudleIndex) {
        goblinFrontMoudleIndex.setUpdateTime(LocalDateTime.now());
        goblinFrontMoudleIndexMapper.updateById(goblinFrontMoudleIndex);
        return true;
    }

    public boolean online(){
        //查出数据
        List<GoblinFrontMoudleIndex> list=this.listGoblinFrontMoudleIndex();
        // mongodb 放入

        // reids 存入
        return  true;
    }

}
