package com.liquidnet.service.kylin.entity;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class KylinOrderImport implements Serializable,Cloneable {

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    private String importId;

    /**
     * performance_id
     */
    private String performanceId;

    /**
     * title 文件名称
     */
    private String title;

    /**
     * status '状态[0-处理中|1处理完成|2处理失败]'
     */
    private Integer status;

    /**
     * error_count 失败条数
     */
    private Integer errorCount;

    /**
     * success_count 成功条数
     */
    private Integer successCount;

    /**
     * all_count 总条数
     */
    private Integer allCount;

    /**
     * created_at
     */
    private LocalDateTime createdAt;

    /**
     * updated_at
     */
    private LocalDateTime updatedAt;

    /**
     * comment
     */
    private String comment;

    private static final KylinOrderImport obj = new KylinOrderImport();
    public static KylinOrderImport getNew() {
        try {
            return (KylinOrderImport) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new KylinOrderImport();
    }
}
