package com.liquidnet.service.feign.goblin.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;

@Component
@FeignClient(name = "liquidnet-service-goblin",
        contextId = "FeignGoblinTaskClient", path = "goblin",
        url = "${liquidnet.service.goblin.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignGoblinTaskClient {

    @GetMapping("rsc/nft/job/goodsList")
    ResponseDto<Boolean> goodsList();

    @GetMapping("rsc/nft/job/goblinNftListStock")
    ResponseDto<Boolean> goblinNftListStock();

    @GetMapping("rsc/nft/job/mixList")
    ResponseDto<Boolean> mixList();

    @GetMapping("/rsc/maizhi/job/getDeviceNumber")
    ResponseDto<Boolean> getDeviceNumber();

    @GetMapping("/rsc/maizhi/job/refundRes")
    ResponseDto<Boolean> refundRes();

}
