package com.liquidnet.service.goblin.controller.Inner;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.IGoblinRechargeWristbandService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "@API:RSC")
@RestController
@Validated
@RequestMapping("/rsc/maizhi/job")
public class GoblinMaiZhiJobController {

    @Autowired
    private IGoblinRechargeWristbandService iGoblinRechargeWristbandService;

    @GetMapping("getDeviceNumber")
    @ApiOperation("获取设备编号JOB")
    public ResponseDto<Boolean> getDeviceNumber() {
        return ResponseDto.success(iGoblinRechargeWristbandService.getDeviceNumber(2));
    }

    @GetMapping("refundRes")
    @ApiOperation("获取设备编号JOB")
    public ResponseDto<Boolean> refundRes() {
        return ResponseDto.success(iGoblinRechargeWristbandService.refundRes());
    }

}
