package com.liquidnet.service.goblin.param;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinNftExActivityParam", description = "添加方法入参")
@Data
public class GoblinNftExActivityParam implements Serializable {

    @ApiModelProperty(position = 10, required = false, value = "nft活动id")
    private String activityId;

    @ApiModelProperty(position = 11, required = true, value = "活动标题", example = "")
    private String title;

    @ApiModelProperty(position = 12, required = true, value = "用户id", example = "")
    private String uid;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 12, required = false, value = "开始时间")
    private LocalDateTime startTime;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 13, required = false, value = "结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty(position = 14, required = true, value = "当前页(查询时传入)", example = "1")
    private Integer pageNum;

}


