package com.liquidnet.service.goblin.param;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

@ApiModel(value = "GoblinNftExActivityDelayParam", description = "该活动下兑换码延期入参")
@Data
public class GoblinNftExActivityDelayParam implements Serializable {

    private static final long serialVersionUID = 5608646910502058970L;

    @ApiModelProperty(position = 10, required = true, value = "老的活动id")
    @NotBlank(message = "老的活动i不能为空")
    private String activityId;

    @ApiModelProperty(position = 11, required = true, value = "活动标题", example = "")
    @NotBlank(message = "活动标题不能为空")
    private String title;

    @ApiModelProperty(position = 12, required = true, value = "用户id", example = "")
    @NotBlank(message = "用户id不能为空")
    private String uid;

    @ApiModelProperty(position = 12, required = true, value = "开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @NotNull(message = "开始时间不能为空")
    private LocalDateTime startTime;

    @ApiModelProperty(position = 13, required = true, value = "结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @NotNull(message = "结束时间不能为空")
    private LocalDateTime endTime;

}


