package com.liquidnet.client.admin.zhengzai.kylin.utils;

import com.liquidnet.client.admin.zhengzai.kylin.dto.PerformanceTicketSumDto;
import com.liquidnet.service.kylin.dao.PerformanceOrderStatisticalDao;

import java.math.BigDecimal;
import java.util.List;

public class DataSumUtils {

    public static PerformanceTicketSumDto sumStatistics(List<PerformanceOrderStatisticalDao> list) {
        // 初始化所有需要统计的字段（BigDecimal类型）
        BigDecimal totalGeneralSum = BigDecimal.ZERO;
        BigDecimal saleGeneralSum = BigDecimal.ZERO;
        BigDecimal surplusGeneralSum = BigDecimal.ZERO;
        BigDecimal vipBuyTotalSum = BigDecimal.ZERO;
        BigDecimal totalPayingNumberSum = BigDecimal.ZERO;
        BigDecimal totalRefundGeneralSum = BigDecimal.ZERO;
        BigDecimal fullRefundTicketTotalSum = BigDecimal.ZERO;
        BigDecimal handlingFeeRefundTicketTotalSum = BigDecimal.ZERO;
        BigDecimal refundFeeRevenueTotalSum = BigDecimal.ZERO;
        BigDecimal audienceSalesAmountTotalSum = BigDecimal.ZERO;

        // 遍历列表进行累加
        for (PerformanceOrderStatisticalDao item : list) {
            // BigDecimal类型字段
            totalGeneralSum = safeAdd(totalGeneralSum, item.getTotalGeneral());
            saleGeneralSum = safeAdd(saleGeneralSum, item.getSaleGeneral());
            surplusGeneralSum = safeAdd(surplusGeneralSum, item.getSurplusGeneral());
            totalPayingNumberSum = safeAdd(totalPayingNumberSum, item.getTotalPayingNumber());
            totalRefundGeneralSum = safeAdd(totalRefundGeneralSum, item.getTotalRefundGeneral());
            refundFeeRevenueTotalSum = safeAdd(refundFeeRevenueTotalSum, item.getRefundFeeRevenueTotal());
            audienceSalesAmountTotalSum = safeAdd(audienceSalesAmountTotalSum, item.getAudienceSalesAmountTotal());

            // Integer类型字段转换
            vipBuyTotalSum = safeAdd(vipBuyTotalSum, BigDecimal.valueOf(item.getVipBuyTotal()));
            fullRefundTicketTotalSum = safeAdd(fullRefundTicketTotalSum, BigDecimal.valueOf(item.getFullRefundTicketTotal()));
            handlingFeeRefundTicketTotalSum = safeAdd(handlingFeeRefundTicketTotalSum,
                    BigDecimal.valueOf(item.getHandlingFeeRefundTicketTotal()));
        }

        PerformanceTicketSumDto sumDto = new PerformanceTicketSumDto();
        sumDto.setTotalGeneralSum(totalGeneralSum); // 库存数量
        sumDto.setSaleGeneralSum(saleGeneralSum); // 销售数量
        sumDto.setSurplusGeneralSum(surplusGeneralSum); // 余票数量
        sumDto.setVipBuyTotalSum(vipBuyTotalSum);//VIP购票数量
        sumDto.setTotalPayingNumberSum(totalPayingNumberSum);//正在支付数量
        sumDto.setTotalRefundGeneralSum(totalRefundGeneralSum);//退票总数量
        sumDto.setFullRefundTicketTotalSum(fullRefundTicketTotalSum);//全额退票数量
        sumDto.setHandlingFeeRefundTicketTotalSum(handlingFeeRefundTicketTotalSum);//手续费退票数量
        sumDto.setRefundFeeRevenueTotalSum(refundFeeRevenueTotalSum);//退票手续费收益
        sumDto.setAudienceSalesAmountTotalSum(audienceSalesAmountTotalSum);//票面销售金额

        return sumDto;
    }

    // 安全的BigDecimal加法（处理null值）
    private static BigDecimal safeAdd(BigDecimal sum, BigDecimal value) {
        if (value == null) {
            return sum;
        }
        return sum.add(value);
    }

}
