package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.entity.SweetDoudou;
import com.liquidnet.service.sweet.mapper.SweetDoudouMapper;
import com.liquidnet.service.sweet.param.SweetDouDouParam;
import com.liquidnet.service.sweet.service.ISweetDoudouService;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.vo.SweetDouDouVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.LinkedList;

/**
 * <p>
 * doudou预约签名CD记录表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2025-06-04
 */
@Service
public class SweetDoudouServiceImpl extends ServiceImpl<SweetDoudouMapper, SweetDoudou> implements ISweetDoudouService {
    @Autowired
    private RedisDataUtils redisDataUtils;
    @Autowired
    QueueUtils queueUtils;

    @Override
    public ResponseDto<SweetDouDouVo> info() {
        String uid = CurrentUtil.getCurrentUid();
        SweetDouDouVo vo = redisDataUtils.getSweetDouDou(uid);
        return ResponseDto.success(vo);
    }

    @Override
    public ResponseDto create(SweetDouDouParam param) {
        String nextSnowId = IDGenerator.nextSnowId();
        String uid = CurrentUtil.getCurrentUid();
        String username = param.getUsername();
        String phone = param.getPhone();
        String platform = param.getPlatform();
        String orderCode = param.getOrderCode();
        String mark = param.getMark();

        SweetDouDouVo entityVo = SweetDouDouVo.getNew();
        entityVo.setDoudouId(nextSnowId);
        entityVo.setUsername(username);
        entityVo.setPhone(phone);
        entityVo.setPlatform(platform);
        entityVo.setOrderCode(orderCode);
        entityVo.setMark(mark);
        entityVo.setUserId(uid);
        entityVo.setStatus(1);


        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("sweet_doudou.insert"));
        sqlsDataA.add(new Object[]{
                nextSnowId, uid, username, phone, platform, orderCode, mark
        });
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_ANSWER_INSERT.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));

        redisDataUtils.setSweetDouDou(entityVo);

        return ResponseDto.success();
    }
}
