package com.liquidnet.service.order.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.goblin.dto.vo.GoblinNftPayResultVo;
import com.liquidnet.service.goblin.param.GoblinNftOrderPayAgainParam;
import com.liquidnet.service.goblin.param.GoblinNftOrderPayCallbackParam;
import com.liquidnet.service.goblin.param.GoblinNftOrderPayParam;
import com.liquidnet.service.goblin.param.GoblinNftOrderRefundCallbackParam;
import com.liquidnet.service.goblin.service.IGoblinNftOrderService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;

@Api(tags = "NFT-支付相关")
@RestController
@Validated
@RequestMapping("/goblin/nft")
public class GoblinNftOrderController {

    @Autowired
    IGoblinNftOrderService iGoblinNftOrderService;

    @PostMapping("pre")
//    @ApiOperation("下单(加密)")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<GoblinNftPayResultVo> checkOrder(@RequestBody @Valid EncryptedReq<GoblinNftOrderPayParam> payParam) {
        return iGoblinNftOrderService.checkOrder(payParam.getData());
    }

    @PostMapping("fc7bce6d6c2213b866f76493f92224b8")
    @ApiOperation("下单(非加密)")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<GoblinNftPayResultVo> checkOrder(@RequestBody @Valid GoblinNftOrderPayParam payParam) {
        return iGoblinNftOrderService.checkOrder(payParam);
    }

    @PostMapping("payAgain")
//    @ApiOperation("再次支付")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<GoblinNftPayResultVo> payAgain(@RequestBody @Valid GoblinNftOrderPayAgainParam param) {
        return iGoblinNftOrderService.payAgain(param);
    }

    @PostMapping("checkPayment")
    @ApiOperation("查询订单状态")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单ID", example = "1"),
    })
    public ResponseDto<Integer> checkOrderResult(@RequestParam("orderId") @NotBlank(message = "订单ID不能为空") String orderId) {
        return iGoblinNftOrderService.checkOrderResult(orderId);
    }

    @PostMapping("syncOrder")
    @ApiOperation("支付回调")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public String syncOrder(GoblinNftOrderPayCallbackParam syncOrderParam) {
        return iGoblinNftOrderService.syncOrder(syncOrderParam);
    }

    @ApiOperation(value = "退款回调")
    @PostMapping(value = "refundSyncOrder")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public String refundSyncOrder(GoblinNftOrderRefundCallbackParam refundCallbackParam) {
        return iGoblinNftOrderService.refundSyncOrder(refundCallbackParam);
    }

    @PostMapping("exchange")
    @ApiOperation("兑换")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "from", required = true, dataType = "String", name = "code", value = "兑换码", example = "1"),
    })
    public ResponseDto<Boolean> exchange(
            @RequestParam("code") @NotBlank(message = "兑换码不能为空") String code
    ) {
        Boolean res = iGoblinNftOrderService.exchange(code);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure();
        }
    }

    /*@PostMapping("exchange")
    @ApiOperation("兑换")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "from", required = true, dataType = "String", name = "code", value = "兑换码", example = "1"),
            @ApiImplicitParam(type = "from", required = true, dataType = "String", name = "user", value = "兑换码", example = "1"),
    })
    public ResponseDto<Boolean> exchange(
            @RequestParam("code") @NotBlank(message = "兑换码不能为空") String code
    ) {
        Boolean res = iGoblinNftOrderService.exchange(code);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure();
        }
    }*/

}
