package com.liquidnet.client.admin.zhengzai.smile.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileOrgAndUserVo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileOrganizationParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileOrganizationVo;
import com.liquidnet.service.smile.entity.SmileOrganization;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
public interface ISmileOrganizationService extends IService<SmileOrganization> {

    /**
     * 组织列表
     * @param smileOrganizationParam ：
     * @return　：TableDataInfo
     */
    TableDataInfo organizationList(SmileOrganizationParam smileOrganizationParam);

    /**
     *  新增组织
     * @param smileOrganizationVo ：
     * @return ：
     */
    AjaxResult create(SmileOrganizationVo smileOrganizationVo);

    /**
     *  修改组织
     * @param smileOrganization ：
     * @return ：
     */
    AjaxResult update(SmileOrganization smileOrganization);

    /**
     * 根据组织id获取信息
     * @param id：组织id
     * @return ：
     */
    SmileOrgAndUserVo getOrgById(Long id);
}
