package com.liquidnet.service.goblin.controller;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderParam;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.IGoblinAppZhengzaiService;
import com.liquidnet.service.goblin.service.IGoblinOrderAppService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Slf4j
@Api(tags = "正在下单相关")
@RestController
@RequestMapping("/zhengzai/app")
public class GoblinAppZhengzaiController {

    @Autowired
    IGoblinAppZhengzaiService goblinAppZhengzaiService;
    //    @Autowired
//    IGoblinOrderService goblinOrderService;
    @Autowired
    IGoblinOrderAppService goblinOrderAppService;

    @GetMapping("market/list")
    @ApiOperation("正在下单-活动列表")
    public ResponseDto<List<GoblinSelfMarketingVo>> getZhengzaiMarketList() {
        return ResponseDto.success(goblinAppZhengzaiService.getZhengzaiMarketList());
    }

    @GetMapping("store/list")
    @ApiOperation("正在下单-参与活动的店铺")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<List<GoblinShowStoreInfoVo>> getStoreList(@RequestParam("marketId") @Valid String marketId) {
        return ResponseDto.success(goblinAppZhengzaiService.getStoreList(marketId));
    }

    @GetMapping("spu/list")
    @ApiOperation("正在下单-参与活动的spu")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "商铺id", example = "1"),
    })
    public ResponseDto<List<GoblinZhengzaiGoodVo>> getStoreList(@RequestParam("marketId") @Valid String marketId,
                                                                @RequestParam("storeId") @Valid String storeId) {
        return ResponseDto.success(goblinAppZhengzaiService.getSpuList(marketId, storeId));
    }

    @PostMapping("listByCode")
    @ApiOperation("列表[根据masterCode]")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderMasterCode", value = "主订单号"),
    })
    public ResponseDto<List<GoblinAppOrderListVo>> orderListByMaster(@RequestParam("orderMasterCode") @Valid String orderMasterCode) {
        return goblinOrderAppService.orderListByMaster(orderMasterCode);
    }

    @PostMapping("details")
    @ApiOperation("详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id", example = "1"),
    })
    public ResponseDto<GoblinAppOrderDetailsVo> orderDetails(@RequestParam("orderId") @Valid String orderId) {
        String uid = CurrentUtil.getCurrentUid();
        return goblinOrderAppService.orderDetails(orderId, uid);
    }

    @PostMapping("orderPush")
    @ApiOperation("正在下单-出货")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "offCode", value = "取货码", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<Boolean> orderPush(@RequestParam("offCode") @Valid String offCode,
                                          @RequestParam("marketId") @Valid String marketId) {
        return goblinAppZhengzaiService.orderPush(offCode, "ZZ" + marketId);
    }

    @PostMapping("orderPushDetails")
    @ApiOperation("正在下单-出货详情")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "offCode", value = "取货码", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<List<GoblinZhengzaiPushVo>> orderPushDetails(@RequestParam("offCode") @Valid String offCode,
                                                                    @RequestParam("marketId") @Valid String marketId) {
        return goblinAppZhengzaiService.orderPushDetails(offCode, "ZZ" + marketId);
    }

    @PostMapping("orderPushDetailsPos")
    @ApiOperation("正在下单-出货详情-Pos")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "offCode", value = "取货码", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "marketId", value = "活动id", example = "1"),
    })
    public ResponseDto<GoblinAppOrderDetailsVo> orderPushDetailsPos(@RequestParam("offCode") @Valid String offCode,
                                                                    @RequestParam("marketId") @Valid String marketId) {
        return goblinAppZhengzaiService.orderPushDetailsPos(offCode, "ZZ" + marketId);
    }

    @PostMapping("orderBind")
    @ApiOperation("正在下单-绑定订单号")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "masterCode", value = "masterCode", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "uid", value = "uid", example = "1"),
    })
    public ResponseDto<Boolean> orderBind(@RequestParam("masterCode") @Valid String masterCode,
                                          @RequestParam("uid") @Valid String uid) {
        return goblinAppZhengzaiService.orderBind(uid, masterCode);
    }

    @PostMapping("mailData")
    @ApiOperation("快递详情")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "orderId", example = "1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mailId", value = "mailId", example = "1"),
    })
    public ResponseDto<List<GoblinMailVo>> getMail(@RequestParam("orderId") @Valid String orderId,
                                                   @RequestParam("mailId") @Valid String mailId) {
        return goblinOrderAppService.getMail(orderId, mailId);
    }
}
