package com.liquidnet.service.adam.service;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.adam.dto.AdamMemberOrderCallbackParam;
import com.liquidnet.service.adam.dto.AdamMemberOrderCodeParam;
import com.liquidnet.service.adam.dto.AdamMemberOrderParam;
import com.liquidnet.service.adam.dto.AdamMemberOrderResult;
import com.liquidnet.service.adam.dto.vo.AdamMemberOrderSimpleVo;
import com.liquidnet.service.base.ResponseDto;

/**
 * 对客户端API接口
 */
public interface IAdamMemberOrderService {
    /**
     * 购买会员或会员码
     *
     * @param param
     */
    ResponseDto<AdamMemberOrderResult> buyMemberOrMemberCode(AdamMemberOrderParam param);

    /**
     * 支付回调
     * @return
     */
    ResponseDto<Object> paymentNotifyCallBack(AdamMemberOrderCallbackParam parameter);

    /**
     * 使用会员码
     * @param param
     * @return
     */
    ResponseDto<AdamMemberOrderResult> exchangeMemberCode(AdamMemberOrderCodeParam param);

    /**
     * 查取会员订单列表
     *
     * @param uid
     * @param pageNo
     * @param pageSize
     * @return
     */
    PageInfo<AdamMemberOrderSimpleVo> queryPage(String uid, int pageNo, int pageSize);
}
