package com.liquidnet.service.account.wallet.vo;

import com.liquidnet.service.account.wallet.entity.FinWallet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * WalletAccountInfo.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/21
 */
@ApiModel(value = "WalletAccountInfoVo", description = "Details of wallet account")
public class WalletAccountInfoVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 1893269218710078026L;
    @ApiModelProperty(position = 11, value = "User association ID [64]")
    private String userExtId;
    @ApiModelProperty(position = 12, value = "User association name [150]")
    private String userExtName;
    @ApiModelProperty(position = 13, value = "Wallet number [11]")
    private String walletNo;
    @ApiModelProperty(position = 14, value = "Wallet currency [5]")
    private String currency;
    @ApiModelProperty(position = 15, value = "Wallet alias [100]")
    private String alias;
    @ApiModelProperty(position = 16, value = "Wallet status code [5]")
    private Integer status;
    @ApiModelProperty(position = 17, value = "Wallet pay status code [5]")
    private Integer payStatus;
    @ApiModelProperty(position = 18, value = "Wallet account opening time")
    private LocalDateTime createTime;
    @ApiModelProperty(position = 19, value = "Wallet account balance(Reserved field)")
    private BigDecimal balance;
    @ApiModelProperty(position = 20, value = "Wallet available balance")
    private BigDecimal balanceAvailable;
    @ApiModelProperty(position = 20, value = "Wallet pending balance")
    private BigDecimal balancePending;
    @ApiModelProperty(position = 20, value = "Wallet frozen balance")
    private BigDecimal balanceFrozen;

    public String getUserExtId() {
        return userExtId;
    }

    public void setUserExtId(String userExtId) {
        this.userExtId = userExtId;
    }

    public String getUserExtName() {
        return userExtName;
    }

    public void setUserExtName(String userExtName) {
        this.userExtName = userExtName;
    }

    public String getWalletNo() {
        return walletNo;
    }

    public void setWalletNo(String walletNo) {
        this.walletNo = walletNo;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public BigDecimal getBalance() {
//        return balance;
        return null == this.balanceAvailable ? this.balancePending : (this.balanceAvailable.add(null == this.balancePending ? BigDecimal.ZERO : this.balancePending));
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getBalanceAvailable() {
        return balanceAvailable;
    }

    public void setBalanceAvailable(BigDecimal balanceAvailable) {
        this.balanceAvailable = balanceAvailable;
    }

    public BigDecimal getBalancePending() {
        return balancePending;
    }

    public void setBalancePending(BigDecimal balancePending) {
        this.balancePending = balancePending;
    }

    public BigDecimal getBalanceFrozen() {
        return balanceFrozen;
    }

    public void setBalanceFrozen(BigDecimal balanceFrozen) {
        this.balanceFrozen = balanceFrozen;
    }

    private static final WalletAccountInfoVo obj = new WalletAccountInfoVo();

    public static WalletAccountInfoVo getNew() {
        try {
            return (WalletAccountInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new WalletAccountInfoVo();
    }

    public WalletAccountInfoVo copy(FinWallet source) {
        this.userExtId = source.getUserExtId();
        this.userExtName = source.getUserExtName();
        this.walletNo = source.getWalletNo();
        this.currency = source.getCurrency();
        this.alias = source.getAlias();
        this.status = source.getStatus();
        this.payStatus = source.getPayStatus();
        this.createTime = source.getCreateTime();
        this.balance = BigDecimal.ZERO;
        this.balanceAvailable = BigDecimal.ZERO;
        this.balancePending = BigDecimal.ZERO;
        this.balanceFrozen = BigDecimal.ZERO;
        return this;
    }
}
