package com.liquidnet.service.account.funding.dto;

import com.liquidnet.service.account.funding.dto.base.FundingCallResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * FundingTransactionResult.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/27
 */
@ApiModel(value = "FundingTransactionResult", description = "Result of funding account transaction")
public class FundingTransactionResult extends FundingCallResult<FundingTransactionParam> {
    private static final long serialVersionUID = 4563547732138114122L;
    @ApiModelProperty(position = 11, required = true, value = "Funding account bill number [32]")
    private String billNo;

    public FundingTransactionResult() {
    }

    public FundingTransactionResult(String billNo) {
        this.billNo = billNo;
    }

    public FundingTransactionResult(String code, String message) {
        super(code, message);
    }

    public String getBillNo() {
        return billNo;
    }
}
