package com.liquidnet.service.goblin.param;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Api
@Data
public class CouponCanUse2Param implements Serializable, Cloneable {
    @ApiModelProperty(dataType = "String", name = "spuId", value = "spuId",example = "1",required = true)
    @NotNull @NotBlank
    private String spuId;
    @ApiModelProperty(dataType = "Number", name = "price", value = "当前spu总价",example = "10",required = true)
    @NotNull @NotBlank
    private BigDecimal price;

    private static final CouponCanUse2Param obj = new CouponCanUse2Param();

    public static CouponCanUse2Param getNew() {
        try {
            return (CouponCanUse2Param) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new CouponCanUse2Param();
    }

}
