package com.liquidnet.service.platform.controller.kylin;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.platform.utils.PerformanceVoTask;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 演出 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-11
 */
@Api(tags = "前端-演出")
@RestController
@RequestMapping("performance")
public class KylinPerformancesController {

    @Autowired
    private PerformanceVoTask performanceVoTask;

    @PostMapping("/checkPerformanceTime")
    @ApiOperation("演出脚本")
    public ResponseDto<String> checkPerformanceTime(@RequestParam(value = "performancesId",required = false)String performancesId){
        try {
            performanceVoTask.performanceVoStatus(performancesId);
            return ResponseDto.success("成功");
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.success("失败");
        }
    }
}
