package com.liquidnet.service.candy.util;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.candy.dto.CandyCouponRuleDto;
import com.liquidnet.service.candy.dto.CandyUserCouponBasicDto;
import com.liquidnet.service.candy.vo.CandyCouponRulesVo;
import com.liquidnet.service.candy.vo.CandyCouponVo;

import java.time.LocalDateTime;
import java.util.List;

public class CouponBaseUtil {

    public static CandyCouponVo getBaseCouponUserVo(CandyUserCouponBasicDto dtoItem) {
        LocalDateTime now = LocalDateTime.now();
        CandyCouponVo vo = CandyCouponVo.getNew();
        List<CandyCouponRulesVo> rulesVoList = ObjectUtil.getCandyCouponRulesVos();
        vo.setTitle(dtoItem.getTitle());
        vo.setExpireAt(DateUtil.format(dtoItem.getExpireAt(), DateUtil.Formatter.yyyy_MM_dd));
        vo.setValFace(dtoItem.getValFace());
        vo.setValOver(dtoItem.getValOver());
        vo.setValMinus(dtoItem.getValMinus());
        vo.setBindType(dtoItem.getBindType());
        vo.setLabel(dtoItem.getLabel());
        vo.setNotice(dtoItem.getNotice());
        vo.setUcouponId(dtoItem.getUcouponId());
        vo.setUsedAt(DateUtil.format(dtoItem.getUsedAt(), DateUtil.Formatter.yyyy_MM_dd));
        vo.setUsedFor(dtoItem.getUsedFor());
        //适用范围 规则
        for (CandyCouponRuleDto ruleItem : dtoItem.getUseRules()) {
            CandyCouponRulesVo voRules = CandyCouponRulesVo.getNew();
            voRules.setUseScope(ruleItem.getUseScope());
            voRules.setBusiId(ruleItem.getBusiId());
            voRules.setBusiName(ruleItem.getBusiName());
            rulesVoList.add(voRules);
        }
        //券类别
        if (dtoItem.getBusiType().equals(3)) {
            vo.setCouType(101);
        } else {
            vo.setCouType(dtoItem.getCouType());
        }
        //券状态
        if (dtoItem.getState().equals(1)) {
            if (now.isAfter(dtoItem.getExpireAt())) {
                vo.setState(3);
            } else {
                vo.setState(dtoItem.getState());
            }
        } else {
            vo.setState(dtoItem.getState());
        }
        vo.setUseRules(rulesVoList);
        return vo;
    }
}
