use dev_ln_scene;
# -- >>------------------------------------------------------------------------------------
alter table adam_real_name add node tinyint default 2 not null comment '认证节点[2-二要素|3-三要素]' after type;

alter table goblin_goods add spu_type tinyint default 0 not null comment '商品类型[0-常规|1-数字藏品]' after spu_no;
alter table goblin_goods add attention varchar(256) null comment '注意事项' after details;
alter table goblin_goods add sale_start_time datetime null comment '开售时间' after shelves_time;
alter table goblin_goods add sale_stop_time datetime null comment '停售时间' after sale_start_time;
alter table goblin_goods add author varchar(100) null comment '创作者' after spu_appear;
alter table goblin_goods add spu_canbuy char null comment '是否购买[0-否|1-是]' after spu_appear;
alter table goblin_goods add publisher varchar(100) null comment '发行方' after author;
# alter table goblin_goods add has_box tinyint default 0 null comment '存在盲盒[0-否|1-是]' after spu_appear;

alter table goblin_goods_sku add sku_type tinyint default 0 not null comment '商品类型[0-常规|1-数字藏品]' after sku_no;
alter table goblin_goods_sku add sku_watch varchar(256) null comment '展示文件URL' after sku_pic;
alter table goblin_goods_sku add watch_type char null comment '展示文件类型[1-图片|2-视频|3-模型]' after sku_watch;
alter table goblin_goods_sku add sku_watch_pic varchar(256) null comment '展示预览图片' after watch_type;
alter table goblin_goods_sku add intro varchar(256) null comment '简介' after weight;
alter table goblin_goods_sku add details text null comment '详情' after intro;

# alter table goblin_goods_sku add gift_stock int null comment '兑换库存' after sku_stock;
alter table goblin_goods_sku add price_v decimal(20, 2) null comment '苹果商品价格' after price;
alter table goblin_goods_sku add product_id varchar(20) null comment '苹果商品价格ID' after price_v;
alter table goblin_goods_sku add shelves_handle char default '1' comment '上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]' after store_id;
alter table goblin_goods_sku add shelves_time datetime null comment '预约上架时间[上架处理方式为3-预约定时上架时需要指定]' after shelves_handle;
alter table goblin_goods_sku add sale_start_time datetime null comment '开售时间' after shelves_time;
alter table goblin_goods_sku add sale_stop_time datetime null comment '停售时间' after sale_start_time;

alter table goblin_goods_sku add soldout_status char default '0' not null comment '是否售罄[0-否|1-是]' after shelves_status;
alter table goblin_goods_sku add sku_canbuy char null comment '是否购买[0-否|1-是]' after sku_appear;
alter table goblin_goods_sku add unbox char default '0' not null null comment '是否盲盒[0-否|1-是]' after sku_canbuy;
alter table goblin_goods_sku add hit_ratio decimal(8, 2) null comment '盲盒命中率[0.00~100%]，0标识不参与盲盒，null标识均摊' after unbox;
alter table goblin_goods_sku add opening_time datetime null comment '盲盒开启时间' after hit_ratio;
alter table goblin_goods_sku add opening_limit int default 0 comment '盲盒开启时限[单位秒]' after opening_time;

# alter table goblin_goods_sku add route_type varchar(20) null comment 'NFT路由' after opening_limit;
# alter table goblin_goods_sku add material_type char null comment '素材原始文件类型[1-图片|2-视频|3-模型]' after watch_type;
# alter table goblin_goods_sku add material_url varchar(256) null comment '素材原始文件URL' after material_type;
# alter table goblin_goods_sku add upchain tinyint default 0 null comment 'NFT上传声明状态[0-待上传|1-已声明|2-声明失败|9-声明中]' after route_type;
# alter table goblin_goods_sku add display_url varchar(500) null comment 'NFT预览图URL' after upchain;
# alter table goblin_goods_sku add nft_url varchar(500) null comment 'NFT素材访问URL' after display_url;
# alter table goblin_goods_sku add series_id varchar(256) null comment 'NFT系列ID' after nft_url;
# alter table goblin_goods_sku add series_hash varchar(256) null comment 'NFT系列HASH' after series_id;
# alter table goblin_goods_sku add nft_hash varchar(25) null comment 'NFT藏品HASH' after series_hash;
# alter table goblin_goods_sku add declare_at varchar(25) null comment 'NFT系列声明时间' after nft_hash;
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_sku_nft;
create table goblin_goods_sku_nft
(
    mid           bigint auto_increment primary key,
    sku_id        varchar(64)  not null comment '单品id',
    route_type    varchar(20)  null comment 'NFT路由',
    material_type char         null comment '素材原始文件类型[1-图片|2-视频|3-模型]',
    material_url  varchar(256) null comment '素材原始文件URL',
    upchain       tinyint default 0 comment 'NFT上传声明状态[0-待上传|1-已声明|2-声明失败|9-声明中]',
    display_url   varchar(500) null comment 'NFT预览图URL',
    nft_url       varchar(500) null comment 'NFT素材访问URL',
    series_id     varchar(256) null comment 'NFT系列ID',
    series_hash   varchar(256) null comment 'NFT系列HASH',
    nft_hash      varchar(256)  null comment 'NFT藏品HASH',
    declare_at    varchar(25)  null comment 'NFT系列声明时间',
    created_at    datetime     not null,
    updated_at    datetime     null,
    comment       varchar(255)
) engine = InnoDB comment '商品NFT信息';

create unique index uidx_ggsn_sku_id on goblin_goods_sku_nft (sku_id);
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_sku_tag;
create table goblin_goods_sku_tag
(
    mid        bigint auto_increment primary key,
    sku_id     varchar(64) not null comment '商品id',
    tag_id     varchar(30) not null comment '标签id，对应 goblin_self_tag.tag_id',
    sort       int  default 0 comment '排序[数值越小,排序越前]',
    tag_belong char default '0' comment '标签所属[0-普通标签|1-专属标签]',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    comment    varchar(255)
) engine = InnoDB comment '商品关联标签';

create unique index uidx_ggst_sku_tag on goblin_goods_sku_tag (sku_id, tag_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_user_digital_artwork;
create table goblin_user_digital_artwork
(
    mid            bigint auto_increment primary key,
    artwork_id     varchar(64)  not null comment '藏品ID',
    uid            varchar(64)  not null comment '用户UID',
    sku_id         varchar(64)  not null comment '单品ID',
    order_id       varchar(64)  not null comment '藏品订单号',
    edition_sn     int          null comment '序列号',
    nft_id         varchar(256) null comment '藏品NFT ID',
    release_txhash varchar(256) null comment '发行HASH',
    release_at     varchar(25)  null comment '发行时间',
    trading_txhash varchar(256) null comment '发放HASH',
    trading_at     varchar(25)  null comment '交易时间',

    source         tinyint      null comment '获得方式[1-购买|2-兑换|3-赠送|5-受赠]',
    state          tinyint default 0 comment '藏品状态[0-生成中/未开启|1-已生成/已开启|2-生成失败/开启失败]',

    del_flg        char    default '0' comment '删除标记[0-未删除|1-删除]',
    opening_at     datetime     null comment '盲盒开启时间',
    created_at     datetime     not null,
    updated_at     datetime     null,
    deleted_at     datetime     null,
    comment        varchar(500)
) engine = InnoDB comment '用户数字藏品信息';
# -- >>------------------------------------------------------------------------------------
# drop table if exists goblin_goods_sku_excode;
# create table goblin_goods_sku_excode
# (
#     mid        bigint auto_increment primary key,
#     sku_id     varchar(64) not null comment '单品ID',
#     num        int comment '生成数量',
#     type       tinyint comment '兑换码类型[0-普通商品|1-数字藏品|2-数字藏品盲盒]',
#
#     code       varchar(64) not null comment '单品兑换码',
#     state      tinyint default 0 comment '兑换码状态[0-未兑换|1-已兑换|10-用作生成模版]',
#     start_at   datetime    null comment '开始时间',
#     stop_at    datetime    null comment '截止时间',
#
#     redeem_uid varchar(64) comment '兑换用户UID',
#     redeem_for varchar(128) comment '兑换内容描述',
#     redeem_at  datetime comment '兑换时间',
#
#     operator   varchar(64),
#     created_at datetime    not null,
#     updated_at datetime    null,
#     deleted_at datetime    null,
#     comment    varchar(500)
# ) engine = InnoDB comment '单品兑换码';
#
# create index idx_ggse_sku_id on goblin_goods_sku_excode (sku_id);
# -- >>------------------------------------------------------------------------------------

DROP TABLE IF EXISTS goblin_nft_order;
CREATE TABLE goblin_nft_order
(
    mid                  BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    order_id             VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '订单id',
    spu_id               VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '商品id',
    sku_id               VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '款式id',
    box_sku_id           VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '盲盒抽取的款式id',
    num                  INT UNSIGNED     NOT NULL DEFAULT 0 COMMENT '数量',
    store_id             VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '店铺id',
    store_name           VARCHAR(255)     NOT NULL DEFAULT '' COMMENT '商铺名称',
    order_code           VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '订单号',
    user_id              VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '用户id',
    user_name            VARCHAR(50)      NOT NULL DEFAULT '' COMMENT '用户昵称',
    user_mobile          VARCHAR(30)      NOT NULL DEFAULT '' COMMENT '用户手机号',
    price_total          DECIMAL(8, 2)    NOT NULL DEFAULT 0 COMMENT '应付金额',
    price_coupon         DECIMAL(8, 2)    NOT NULL DEFAULT 0 COMMENT '券优惠金额',
    store_price_coupon   DECIMAL(8, 2)    NOT NULL DEFAULT 0 COMMENT '商铺券优惠金额',
    price_red_envelope   DECIMAL(8, 2)    NOT NULL DEFAULT 0 COMMENT '红包优惠金额',
    price_voucher        DECIMAL(8, 2)    NOT NULL DEFAULT 0 COMMENT '总优惠价格',
    price_actual         DECIMAL(8, 2)    NOT NULL DEFAULT 0 COMMENT '实付金额',
    ucoupon_id           VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '券id',
    store_coupon_id      VARCHAR(255)     NOT NULL DEFAULT '' COMMENT '商铺券id',
    red_envelope_code    VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '红包code',
    status               TINYINT UNSIGNED NOT NULL DEFAULT 0 COMMENT '订单状态 1待付款 2已付款 3未付款取消订单 4退款中 5已退款',
    source               VARCHAR(32)      NOT NULL DEFAULT '' COMMENT '订单来源 app h5 applet',
    order_type           TINYINT UNSIGNED NOT NULL DEFAULT 0 COMMENT '订单类型 1购买订单 2兑换订单 3演出赠送订单',
    pay_type             VARCHAR(32)      NOT NULL DEFAULT '' COMMENT '支付类型 wepay微信 alipay阿里 douyinpay抖音 unionpay银联 applepay苹果支付',
    device_from          VARCHAR(32)      NOT NULL DEFAULT '' COMMENT '支付终端 app wap js applet',
    version              VARCHAR(32)      NOT NULL DEFAULT '' COMMENT '版本号',
    pay_countdown_minute TINYINT UNSIGNED          DEFAULT 5 COMMENT '订单过期时间(分钟)',
    pay_time             DATETIME         NULL     DEFAULT NULL COMMENT '支付时间',
    pay_code             VARCHAR(64)      NOT NULL DEFAULT '' COMMENT '支付单号',
    payment_type         VARCHAR(32)      NOT NULL DEFAULT '' COMMENT '支付中心返回实际支付类型',
    payment_id           VARCHAR(128)     NOT NULL DEFAULT '' COMMENT '支付中心返回支付id',
    cancel_reason        VARCHAR(256)     NOT NULL DEFAULT '' COMMENT '取消原因',
    cancel_time          DATETIME         NULL     DEFAULT NULL COMMENT '取消时间',
    ip_address           VARCHAR(32)               DEFAULT '' COMMENT 'ip地址',
    created_at           DATETIME         NULL     DEFAULT NULL COMMENT '创建时间',
    updated_at           DATETIME         NULL     DEFAULT NULL COMMENT '更新时间',
    KEY `nft_order_id_index` (`order_id`),
    KEY `nft_order_code_index` (`order_code`),
    KEY `nft_store_id_index` (`store_id`),
    KEY `nft_sku_id_index` (`sku_id`),
    KEY `nft_user_id_index` (`user_id`),
    KEY `nft_ucoupon_id_index` (`ucoupon_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT 'NFT订单表';
# -- >>------------------------------------------------------------------------------------
DROP TABLE IF EXISTS goblin_nft_order_refund;
CREATE TABLE goblin_nft_order_refund
(
    mid             BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    order_refund_id VARCHAR(64)   NOT NULL DEFAULT '' COMMENT '订单退单表id',
    refund_code     VARCHAR(64)   NOT NULL DEFAULT '' COMMENT '退款单号',
    order_id        VARCHAR(64)   NOT NULL DEFAULT '' COMMENT '订单id',
    order_code      VARCHAR(64)   NOT NULL DEFAULT '' COMMENT '订单编号',
    store_id        VARCHAR(64)   NOT NULL DEFAULT '' COMMENT '商铺id',
    user_id         VARCHAR(64)   NOT NULL DEFAULT '' COMMENT '用户id',
    price           DECIMAL(8, 2) NOT NULL DEFAULT 0 COMMENT '退款金额',
    status          INT UNSIGNED  NOT NULL DEFAULT 0 COMMENT '退款状态 1申请 2退款成功 3退款失败',
    refund_at       DATETIME      NULL     DEFAULT NULL COMMENT '退款时间',
    error_reason    VARCHAR(255)  NOT NULL DEFAULT '' COMMENT '退款失败原因',
    created_at      DATETIME      NULL     DEFAULT NULL COMMENT '创建时间',
    updated_at      DATETIME      NULL     DEFAULT NULL COMMENT '更新时间',
    KEY `nft_refund__index` (`order_refund_id`),
    KEY `nft_refund_refund_code_index` (`refund_code`),
    KEY `nft_refund_order_id_index` (`order_id`),
    KEY `nft_refund_order_code_index` (`order_code`),
    KEY `nft_refund_store_id_index` (`store_id`),
    KEY `nft_refund_user_id_index` (`user_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT 'NFT订单退款表';

  # -- >>------------------------------------------------------------------------------------
DROP TABLE IF EXISTS `goblin_goods_anticipate_user`;
CREATE TABLE `goblin_goods_anticipate_user`  (
                                                 `id` bigint NOT NULL AUTO_INCREMENT COMMENT '主键id',
                                                 `uid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户id',
                                                 `phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '手机号',
                                                 `sku_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'sku_id',
                                                 `state` int NOT NULL DEFAULT 0 COMMENT '状态（0：正常（默认））',
                                                 `created_date` datetime NULL DEFAULT NULL COMMENT '创建时间',
                                                 PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '预约表关联user表' ROW_FORMAT = Dynamic;

# -- >>------------------------------------------------------------------------------------

DROP TABLE IF EXISTS `goblin_goods_anticipate_value`;
CREATE TABLE `goblin_goods_anticipate_value`  (
                                                  `id` bigint NOT NULL AUTO_INCREMENT COMMENT '自增主键id',
                                                  `uid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'uid',
                                                  `ant_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '预约id 对应(goblin_goods_anticipate.id)',
                                                  `sku_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'sku名称',
                                                  `sku_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'sku_id 对应 goblin_goods_sku.sku_id',
                                                  `spu_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'spu_id对应 goblin_goods_spu_id',
                                                  `about_people` bigint NULL DEFAULT NULL COMMENT '预约人数',
                                                  `actual_people` bigint NULL DEFAULT NULL COMMENT '实际预约人数',
                                                  `rule` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '预约规则',
                                                  `about_start_date` datetime NOT NULL COMMENT '预约开始时间',
                                                  `about_end_date` datetime NOT NULL COMMENT '预约结束时间',
                                                  `created_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                                  `update_date` datetime NULL DEFAULT NULL COMMENT '修改时间',
                                                  `del_tag` int NOT NULL DEFAULT 0 COMMENT '删除（0:未删除1:已删除）',
                                                  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '预约关联sku和spu表' ROW_FORMAT = Dynamic;

# -- >>------------------------------------------------------------------------------------

DROP TABLE IF EXISTS `goblin_goods_anticipate`;
CREATE TABLE `goblin_goods_anticipate`  (
                                            `id` bigint NOT NULL AUTO_INCREMENT COMMENT '自增主键id',
                                            `ant_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ant_id',
                                            `people` bigint NOT NULL COMMENT '预约人数（达到一定人数可以预约）',
                                            `type` int NOT NULL COMMENT '预约类型（1：预约提醒，2：预约获得购买资格）',
                                            `rule` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '预约规则',
                                            `created_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
                                            `del_tag` int NOT NULL DEFAULT 0 COMMENT '删除（0:未删除1:已删除）',
                                            PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '预约规则表' ROW_FORMAT = Dynamic;
# -- >>------------------------------------------------------------------------------------

DROP TABLE IF EXISTS `goblin_goods_anticipate_help`;
CREATE TABLE `goblin_goods_anticipate_help`  (
                                                 `id` bigint NOT NULL AUTO_INCREMENT COMMENT 'id',
                                                 `sid` varbinary(255) NOT NULL COMMENT '分享sid',
                                                 `help_uid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '助力人uid',
                                                 `created_date` datetime NOT NULL COMMENT '创建时间',
                                                 PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '预约他人助力记录表' ROW_FORMAT = Dynamic;
# -- >>------------------------------------------------------------------------------------

DROP TABLE IF EXISTS `goblin_goods_anticipate_share`;
CREATE TABLE `goblin_goods_anticipate_share`  (
                                                  `sid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键ID',
                                                  `uid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户uid',
                                                  `sku_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'sku_Id',
                                                  `created_date` datetime NOT NULL COMMENT '创建时间',
                                                  PRIMARY KEY (`sid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '预约创建助力表' ROW_FORMAT = Dynamic;
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------

alter table dragon_orders add receipt_data text comment '苹果支付回调的code';


#----               NFT——galaxy             ----
drop TABLE if exists `galaxy_user_info`;
create table galaxy_user_info
(
    mid bigint unsigned NOT NULL AUTO_INCREMENT,
    user_id varchar(200)  NOT NULL COMMENT '用户ID',
    user_name varchar(200)  NOT NULL COMMENT '用户姓名',
    user_type varchar(3)  NOT NULL DEFAULT '2' COMMENT '1企业 2个人',
    mobile varchar(20) COMMENT '移动手机号',
    id_card_type varchar(3)  NOT NULL COMMENT '证件类型( 1-身份证 2-护照 3-港澳通行证 4-台湾通行证 5-外国人永居身份证 6-港澳台居民居住证 7-其它)',
    id_card varchar(50)  NOT NULL COMMENT '证件号码',
    mnemonic varchar(200)  COMMENT '助记词',
    mnemonic_index varchar(3)  NOT NULL DEFAULT '0' COMMENT '助记词索引',
    user_identification varchar(200) COMMENT '用户链上唯一ID',
    user_pub_key varchar(500) COMMENT '用户公钥',
    user_pri_key varchar(500) COMMENT '用户私钥',
    block_chain_address varchar(200) COMMENT '区块链地址',
    router_type varchar(200)  NOT NULL COMMENT '路由类型(zxinchain、eth、antchain)',
    created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB comment '数字藏品用户信息';
create index gui_idx_user_id on galaxy_user_info (user_id);


drop TABLE if exists `galaxy_series_info`;
create table galaxy_series_info
(
    mid bigint unsigned NOT NULL AUTO_INCREMENT,
    series_info_id varchar(100) NOT NULL COMMENT '系列存储ID',
    series_name varchar(28) NOT NULL COMMENT '本地系列唯一名称(前缀+skuid)',
    series_code varchar(200) NOT NULL COMMENT '系列编码',
    series_id varchar(200) COMMENT '区块链上系列ID',
    total_count varchar(50)   COMMENT '系列发行总量',
    crt_count varchar(200)   COMMENT '系列已发行个数',
    series_claim_task_id varchar(200)   COMMENT '系列声明任务ID',
    series_claim_status varchar(200)   COMMENT '系列声明状态',
    cover_url varchar(1000)   COMMENT '系列显示封面',
    series_desc varchar(200)   COMMENT '系列描述信息，不超过500个字符',
    chain_timestamp varchar(30)   COMMENT '系列链上声明时间',
    trade_hash varchar(100)   COMMENT '系列链上交易hash',
    nft_count int default 0 COMMENT '系列中包含nft个数',
    router_type varchar(200)  NOT NULL COMMENT '路由类型(zxinchain、eth、antchain)',
    created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB comment '数字藏品系列信息';

create index gsi_idx_series_code on galaxy_series_info (series_code);

create index gsi_idx_series_info_id on galaxy_series_info (series_info_id);


drop TABLE if exists `galaxy_series_nft_info`;
create table galaxy_series_nft_info
(
    mid bigint unsigned NOT NULL AUTO_INCREMENT,
    series_nft_info_id varchar(100) NOT NULL COMMENT '系列nft存储ID',
    series_info_id varchar(100) NOT NULL COMMENT '系列存储ID',
    sku_id varchar(200)  NOT NULL  COMMENT '本地系列nft唯一标识id',
    series_name varchar(28) NOT NULL COMMENT '本地系列唯一名称(前缀+skuid)',
    series_code varchar(200) NOT NULL COMMENT '本地系列唯一编码',
    series_id varchar(200) COMMENT '区块链上系列ID',
    nft_total_count varchar(50)   COMMENT '系列nft发行总量',
    nft_crt_count varchar(200)   COMMENT '系列nft已发行个数',
    nft_id_begin varchar(200) COMMENT '系列nft发行开始id',
    nft_id_begin_index int default 0  COMMENT 'nftId开始索引',
    nft_publish_number int default 1  COMMENT 'nft系列发行序号',
    original_nft_url varchar(1000)   COMMENT 'nft素材原始地址',
    original_display_url varchar(1000)   COMMENT 'nft显示素材原始地址',
    author varchar(200)   COMMENT '作者名',
    nft_name varchar(200)   COMMENT 'nft名字(sku名称)',
    nft_url varchar(1000)   COMMENT 'nft素材地址',
    display_url varchar(1000)   COMMENT '预览图url，不超过1024个字符',
    nft_desc varchar(400)   COMMENT 'nft简介，500个字符以内',
    nft_flag varchar(200)   COMMENT '标签，【文创】，游戏，动漫，30个字符以内',
    sell_count varchar(200)   COMMENT '可售状态下有意义',
    nft_hash varchar(200) COMMENT ' 系列声明中nftHash',
    router_type varchar(200)  NOT NULL COMMENT '路由类型(zxinchain、eth、antchain)',
    created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB comment '数字藏品系列nft信息';
-- alter table galaxy_series_nft_info add nft_id_begin_index int default 0 comment 'nftId开始索引' after nft_id_begin;
-- alter table galaxy_series_nft_info add nft_publish_number int default 1 comment 'nft系列发行序号' after nft_id_begin_index;
create index gsni_idx_series_nft_info_id on galaxy_series_nft_info (series_nft_info_id);
create index gsni_idx_series_info_id on galaxy_series_nft_info (series_info_id);
create index gsni_idx_sku_id on galaxy_series_nft_info (sku_id);
create index gsni_idx_series_code on galaxy_series_nft_info (series_code);

drop TABLE if exists `galaxy_nft_order_info`;
create table galaxy_nft_order_info
(
    mid bigint unsigned NOT NULL AUTO_INCREMENT,
    nft_order_pay_id varchar(100)   COMMENT '订单支付唯一ID',
    user_id varchar(200)  NOT NULL COMMENT '用户ID',
    sku_id varchar(200)  NOT NULL  COMMENT '应用系统购买系列唯一ID',
    series_name varchar(28) NOT NULL COMMENT '系列的唯一名称(前缀+skuid)',
    series_id varchar(200) COMMENT '系列的唯一Id',
    series_code varchar(200) NOT NULL COMMENT '本地系列唯一编码',
    nft_id varchar(200)   COMMENT 'nftId',
    nft_name varchar(200)   COMMENT 'nft名字(sku名称)',
    nft_price varchar(50)   COMMENT 'nft购买价格',
    nft_publish_task_id varchar(100)   COMMENT 'nft发行任务id',
    nft_publish_from_address varchar(200)   COMMENT 'nft发行转出方地址',
    nft_publish_to_address varchar(200)   COMMENT 'nft发行转入方地址',
    nft_publish_chain_timestamp varchar(30)   COMMENT 'nft发行时间',
    nft_publish_status varchar(30)   COMMENT 'nft发行状态',
    nft_publish_trade_hash varchar(100)   COMMENT 'nft发行交易hash',
    nft_buy_task_id varchar(100)   COMMENT 'nft购买任务id',
    nft_buy_from_address varchar(200)   COMMENT 'nft购买转出方地址',
    nft_buy_to_address varchar(200)   COMMENT 'nft购买转入方地址',
    nft_buy_chain_timestamp varchar(30)   COMMENT 'nft购买时间',
    nft_buy_status varchar(30)   COMMENT 'nft购买状态',
    nft_buy_trade_hash varchar(100)   COMMENT 'nft购买交易hash',
    nft_buy_pay_task_id varchar(100)   COMMENT 'nft购买支付任务id',
    router_type varchar(20)  NOT NULL COMMENT '路由类型(zxinchain、eth、antchain)',
    created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB comment '数字藏品订单信息';
-- alter table galaxy_nft_order_info add nft_name varchar(200) comment 'nft名字' after nft_id;
create index gsoi_idx_nft_order_pay_id on galaxy_nft_order_info (nft_order_pay_id);
create index gsoi_idx_user_id on galaxy_nft_order_info (user_id);
create index gsoi_idx_sku_id on galaxy_nft_order_info (sku_id);
create index gsoi_idx_series_code on galaxy_nft_order_info (series_code);


drop TABLE if exists `galaxy_nft_trade_info`;
create table galaxy_nft_trade_info
(
    mid bigint unsigned NOT NULL AUTO_INCREMENT,
    user_id varchar(200)  NOT NULL COMMENT '用户ID',
    nft_id varchar(200)   COMMENT 'nftId',
    nft_name varchar(200)   COMMENT 'nft名字(sku名称)',
    series_name varchar(28) NOT NULL COMMENT '系列的唯一名称',
    series_id varchar(200) COMMENT '系列的唯一Id',
    series_code varchar(200) NOT NULL COMMENT '本地系列唯一编码',
    trade_hash varchar(200)   COMMENT '交易hash',
    chain_timestamp varchar(20)   COMMENT '链上交易时间戳',
    from_address varchar(200)   COMMENT '转出方地址',
    to_address varchar(200)   COMMENT '转入方地址',
    trade_price bigint COMMENT '交易价格',
    trade_type varchar(3)   COMMENT '交易类别 1发行 2购买 3转移 4设置价格 5设置状态',
    router_type varchar(20)  NOT NULL COMMENT '路由类型(zxinchain、eth、antchain)',
    created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB comment '数字藏品交易信息';

create index gnti_idx_user_id on galaxy_nft_trade_info (user_id);
create index gnti_idx_nft_id on galaxy_nft_trade_info (nft_id);
create index gnti_idx_series_code on galaxy_nft_trade_info (series_code);


drop TABLE if exists `galaxy_nft_order_fail_log`;
create table galaxy_nft_order_fail_log
(
    mid bigint unsigned NOT NULL AUTO_INCREMENT,
    nft_order_pay_id varchar(100)   COMMENT '订单支付唯一ID',
    user_id varchar(200)  NOT NULL COMMENT '用户ID',
    nft_id varchar(200)   COMMENT 'nftId',
    nft_name varchar(200)   COMMENT 'nft名字(sku名称)',
    series_name varchar(28) NOT NULL COMMENT '系列的唯一名称',
    series_id varchar(200) COMMENT '系列的唯一Id',
    series_code varchar(200) NOT NULL COMMENT '本地系列唯一编码',
    taskId varchar(100)   COMMENT '任务ID',
    fail_reason_desc varchar(20)   COMMENT '失败原因',
    fail_reason_desc_second varchar(20)   COMMENT '失败原因2',
    trade_type varchar(3)   COMMENT '交易类别 1发行 2购买 3转移 4设置价格 5设置状态',
    router_type varchar(20)  NOT NULL COMMENT '路由类型(zxinchain、eth、antchain)',
    deal_with_status varchar(3)   COMMENT '处理状态 0数据初始化 1已处理成功 2处理失败 3不做处理',
    created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB comment '数字藏品发行购买失败记录表';
create index gnofl_idx_nft_order_pay_id on galaxy_nft_order_fail_log (nft_order_pay_id);
create index gnofl_idx_user_id on galaxy_nft_order_fail_log (user_id);
create index gnofl_idx_nft_id on galaxy_nft_order_fail_log (nft_id);
create index gnofl_idx_series_code on galaxy_nft_order_fail_log (series_code);

# ----              CONFIG 修改               ----
# ---- liquidnet-client-admin-web.yml url7: "/goblin/common/goods?type=0" #商品 url9: "/goblin/common/goods?type=1" #NFT