package com.liquidnet.client.admin.web.controller.zhengzai.adam;

import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberAdminService;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberCodeAdminService;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.AdamMemberCodeParam;
import com.liquidnet.service.adam.dto.AdamMemberParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.util.ArrayList;
import java.util.List;

@Api(tags = "会员信息")
@Slf4j
@Validated
@RestController
@RequestMapping("adam/member")
public class AdamMemberAdminController {
    @Autowired
    IAdamMemberAdminService adamMemberService;
    @Autowired
    IAdamMemberCodeAdminService adamMemberCodeAdminService;
    @Autowired
    RedisUtil redisUtil;

    @RequiresPermissions("adam:member:list")
    @ApiOperation(value = "会员卡列表")
    @PostMapping("list")
    public ResponseDto<List<AdamMemberVo>> list() {
        List<AdamMember> list = adamMemberService.list();
        List<AdamMemberVo> vos = new ArrayList<>();
        list.forEach(r -> {
            vos.add(AdamMemberVo.getNew().copy(r));
        });
        return ResponseDto.success(vos);
    }

    @RequiresPermissions("adam:member:add")
    @ApiOperation(value = "添加会员卡")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestBody AdamMemberParam parameter) {
        return ResponseDto.success(adamMemberService.add(parameter));
    }

    @RequiresPermissions("adam:member:gen_code")
    @ApiOperation(value = "生成兑换码")
    @PostMapping("gen_code")
    public ResponseDto<String> genMemberCode(@RequestBody AdamMemberCodeParam parameter) {
        return ResponseDto.success(adamMemberCodeAdminService.createGiftCode(parameter));
    }

    @RequiresPermissions("adam:member:switch:buy")
    @ApiOperation(value = "开放/限制购买会员")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "int", name = "opt", value = "0-限制｜1-开放", example = "0"),
    })
    @PostMapping("switch/buy")
    public ResponseDto<Object> purchaseSwitch(@Max(1) @Min(0) @RequestParam int opt) {
        redisUtil.set(AdamRedisConst.SWITCH_BUY_MEMBER, opt);
        return ResponseDto.success(redisUtil.get(AdamRedisConst.SWITCH_BUY_MEMBER));
    }
}
