package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.service.adam.entity.AdamMemberRights;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(value = "AdamMemberRightsVo", description = "会员权益详情")
public class AdamMemberRightsDetailVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -2407106925001008460L;
    @ApiModelProperty(position = 1, value = "权益信息")
    private AdamMemberRightsVo rightsVo;

    @ApiModelProperty(position = 11, value = "专享券列表")
    private List<AdamMemberRightsCouponVo> couponVoList;

    public AdamMemberRightsVo getRightsVo() {
        return rightsVo;
    }

    public AdamMemberRightsDetailVo setRightsVo(AdamMemberRightsVo rightsVo) {
        this.rightsVo = rightsVo;
        return this;
    }

    public List<AdamMemberRightsCouponVo> getCouponVoList() {
        return couponVoList;
    }

    public AdamMemberRightsDetailVo setCouponVoList(List<AdamMemberRightsCouponVo> couponVoList) {
        this.couponVoList = couponVoList;
        return this;
    }

    private static final AdamMemberRightsDetailVo obj = new AdamMemberRightsDetailVo();

    public static AdamMemberRightsDetailVo getNew() {
        try {
            return (AdamMemberRightsDetailVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberRightsDetailVo();
        }
    }
}
