package com.liquidnet.service.feign.dragon.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;

@Component
@FeignClient(name = "liquidnet-service-dragon",
        contextId = "FeignDragonTaskClient", path = "",
        url = "${liquidnet.service.platform.url}",
//        url = "",
        fallback = FallbackFactory.Default.class)
public interface FeignDragonTaskClient {

    @PostMapping("platform/dragon/handleNotifyFail")
    ResponseDto<Boolean> handleNotifyFail();
}
