package com.liquidnet.service.candy.util;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.candy.constant.CandyRedisConst;
import com.liquidnet.service.candy.dto.CandyCouponCodeDto;
import com.liquidnet.service.candy.dto.CandyCouponInfoDto;
import com.liquidnet.service.candy.dto.CandyUserCouponBasicDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class RedisDataUtils {

    @Autowired
    RedisUtil redisUtil;

    // 获取 CandyUserCouponBasicDto数组 根据用户id
    public List<CandyUserCouponBasicDto> getCouponByUid(String uid) {
        String redisKey = CandyRedisConst.BASIC_USER_COUPON.concat(uid);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            //降级
            return new ArrayList();
        } else {
            return (List<CandyUserCouponBasicDto>) obj;
        }
    }

    // 覆盖 CandyUserCouponBasicDto数组 根据用户id
    public void setCouponByUid(String uid, List<CandyUserCouponBasicDto> dtoList) {
        String redisKey = CandyRedisConst.BASIC_USER_COUPON.concat(uid);
        redisUtil.set(redisKey, dtoList);
    }

    // 添加 CandyUserCouponBasicDto数组  item
    public void addCouponByUid(String uid, CandyUserCouponBasicDto dto) {
        List<CandyUserCouponBasicDto> dtoList = getCouponByUid(uid);
        dtoList.add(dto);
        setCouponByUid(uid,dtoList);
    }

    //获取 CandyCouponCodeDto 根据 ccode
    public CandyCouponCodeDto getCouponByCode(String ccode) {
        String redisKey = CandyRedisConst.BASIC_COUPON_CODE.concat(ccode);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            //降级
            return null;
        } else {
            return (CandyCouponCodeDto) obj;
        }
    }

    //删除 CandyCouponCodeDto 根据 ccode
    public void delCouponByCode(String ccode) {
        String redisKey = CandyRedisConst.BASIC_COUPON_CODE.concat(ccode);
        redisUtil.del(redisKey);
    }

    //获取 CandyCouponInfoDto 根据 couponId
    public CandyCouponInfoDto getCouponInfo(String couponId) {
        String redisKey = CandyRedisConst.BASIC_COUPON_INFO.concat(couponId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            //降级
            return null;
        } else {
            return (CandyCouponInfoDto) obj;
        }
    }
}
