package com.liquidnet.service.galaxy.constant;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyErrorCodeEnum
 * @Package com.liquidnet.service.galaxy.constant
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/8 11:25
 */
public enum GalaxyErrorEnum {
    SERIES_CLAIM_ERROR("NFT0010001","NFT系列声明失败"),
    SERIES_CLAIM_ERROR_FIVE_TIMES("NFT0010002","NFT系列声明失败,任务查询超过5次"),
    PUBLISH_FAIL("NFT0010003","NFT发行失败,未获取nft"),
    PUBLISH_BUY_FAIL("NFT0010004","NFT发行购买失败,未发起购买"),
    PUBLISH_FAIL_ALREADY_EXIST("NFT0010005","NFT发行失败,该订单已经发行过指定nft！"),
    ROUTER_NOT_EXIST("NFT0010006","路由类型不存在"),
    SERIES_NOT_EXIST("NFT0010007","没有查询到该sku对应系列声明"),
    SERIES_CLAIM_PROCESSING("NFT0010008","系列声明正在处理中,不允许重复声明！"),
    SERIES_CLAIM_SUCCESSED("NFT0010009","系列已声明成功，不允许重复声明！"),
    SERIES_CLAIM_NOT_EXIST("NFT0010010","系列声明初始化信息不存在，请检查是否已上传对应素材！"),
    PUBLISH_ORDER_NOT_EXIST("NFT0010011","NFT购买订单不存在!"),
    NFT_BUY_TASK_NOT_EXIST("NFT0010012","NFT购买执行任务不存在"),
    NFT_BUY_TASK_HAVE_EXIST("NFT0010013","NFT购买执行任务已存在，不可以重复购买!"),
    NFT_BUY_FAIL("NFT0010014","NFT购买失败，nftId不存在!"),
    NFT_BUY_FAIL_USER_NOT_EXIST("NFT0010015","NFT购买失败，用户信息不存在!"),
    NFT_BUY_FAIL_SERIES_NFT_NOT_EXIST("NFT0010016","NFT购买失败，系列NFT信息不存在!"),
    NFT_PUBLISH_ERROR("NFT0010017","NFT发行异常!"),
    NFT_BUY_ERROR("NFT0010018","NFT购买异常!"),
    NFT_PUBLISH_AND_BUY_QUERY_FAIL("NFT0010019","NFT发行和购买结果查询失败!"),
    NFT_QUERY_FAIL_ORDER_NOT_EXIST("NFT0010020","NFT订单不存在!"),
    NFT_QUERY_FAIL_NFT_NOT_EXIST("NFT0010021","NFT信息查询不存在!"),
    NFT_QUERY_FAIL_SERIES_NOT_EXIST("NFT0010022","系列信息查询不存在!"),
    NFT_USER_HAS_OPEN_ACCOUNT("NFT0010023","用户已经开通过数字账户!"),
    SERIES_NFT_INFO_NOT_EXIST("NFT0010024","系列NFT信息查询不存在！"),
    SERIES_NFT_HASH_CREATE_FAIL("NFT0010025","系列NFT的介质hash生成失败！"),
    NFT_TRANSFER_FAIL("NFT0010026","NFT转让失败"),
    NFT_TRANSFER_FAIL_OWNER_NOT_EXIST("NFT0010027","NFT转让失败，拥有者不存在!"),
    NFT_TRANSFER_FAIL_RECEIVER_NOT_EXIST("NFT0010028","NFT转让失败，接收者不存在!"),
    NFT_TRANSFER_OWNER_MATCH_ERROR("NFT0010029","NFT转让失败，拥有者不匹配"),
    NFT_TRANSFERING_ERROR("NFT0010030","NFT正在转让中，不允许再次操作！"),
    NFT_TRANSFER_NFTID_FORMAT_ERROR("NFT0010031","NFT转让失败，nftid格式错误！"),
    NFT_TRANSFER_QUERY_ERROR("NFT0010032","NFT转让结果查询失败，nft信息不存在！");


    private String code;
    private String message;
    GalaxyErrorEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }
    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
