package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 51.NFT销售状态变更查询 GET请求方式
 * @class: NftStatusUpdateResultReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:59
 */
@Data
public class Nft051StatusUpdateResultReq implements Serializable {
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 任务ID
     */
    private String taskId;
    private static final Nft051StatusUpdateResultReq obj = new Nft051StatusUpdateResultReq();
    private static final long serialVersionUID = 3476736062114976846L;

    public static Nft051StatusUpdateResultReq getNew() {
        try {
            return (Nft051StatusUpdateResultReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft051StatusUpdateResultReq();
        }
    }
}
