package com.liquidnet.service.executor.main.handler;

import com.liquidnet.service.feign.goblin.task.FeignGoblinTaskClient;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * XxlJob开发示例（Bean模式）
 * <p>
 * 开发步骤：
 * 1、在Spring Bean实例中，开发Job方法，方式格式要求为 "public void execute(String param)"
 * 2、为Job方法添加注解 "@XxlJob(value="自定义jobhandler名称", init = "JobHandler初始化方法", destroy = "JobHandler销毁方法")"，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 * 3、执行日志：需要通过 "XxlJobLogger.log" 打印执行日志；
 */
@Component
public class GoblinTaskHandler {
    @Autowired
    private FeignGoblinTaskClient feignGoblinTaskClient;

    @XxlJob(value = "sev-goblin:goodsList")
    public void goodsList() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignGoblinTaskClient.goodsList().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-goblin:rollbackNftStock")
    public void goblinNftListStock() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignGoblinTaskClient.goblinNftListStock().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-goblin:mixList")
    public void mixList() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignGoblinTaskClient.mixList().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-goblin:getDeviceNumber")
    public void getDeviceNumber() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignGoblinTaskClient.getDeviceNumber().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }

    @XxlJob(value = "sev-goblin:refundRes")
    public void refundRes() {
        try {
            XxlJobHelper.handleSuccess("结果：" + feignGoblinTaskClient.refundRes().getData());
        } catch (Exception e) {
            XxlJobHelper.log(e);
            XxlJobHelper.handleFail();
        }
    }
}
