package com.liquidnet.client.admin.zhengzai.smile.utils;

import com.liquidnet.client.admin.zhengzai.smile.dto.ShowVo;
import com.liquidnet.client.admin.zhengzai.smile.dto.UserData;
import com.liquidnet.service.goblin.dto.vo.SmileProjectDetailsVo;
import com.liquidnet.common.cache.redis.util.AbstractRedisUtil;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SmileAgentVo;
import com.liquidnet.service.goblin.dto.vo.SmileSchoolVo;
import com.liquidnet.service.goblin.dto.vo.SmileSellDataVO;
import com.liquidnet.service.goblin.dto.vo.SmileUserVO;
import com.liquidnet.service.smile.entity.SmileVolunteersTeam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Component
@Slf4j
public class SmileRedisUtils {

    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;


    public AbstractRedisUtil getRedis() {
        return redisDataSourceUtil.getRedisKylinUtil();
    }

    public Object get(String key){
        return redisDataSourceUtil.getRedisKylinUtil().get(key);
    }

    /**
     * redis保存用户
     */
    public void setSmileUserVO(String uid, SmileUserVO smileUserVO) {
        getRedis().set(SmileRedisConst.SMILE_USER.concat(uid), smileUserVO);
    }

    /**
     * redis获取SmileUserVO
     */
    public SmileUserVO getSmileUserVO(String uid) {
        return (SmileUserVO) getRedis().get(SmileRedisConst.SMILE_USER.concat(uid));
    }

    /**
     * 根据学校id获取学校名称
     */
    public String getSchoolNameById(String schoolId) {
        return (String) getRedis().get(SmileRedisConst.SMILE_SCHOOL.concat(":").concat(schoolId));
    }

    /**
     * 根据学校id删除学校
     */
    public void delSchoolNameById(String schoolId) {
        getRedis().del(SmileRedisConst.SMILE_SCHOOL.concat(":").concat(schoolId));
    }

    /**
     * 保存/更新学校
     */
    public void setSchool(String schoolId, String schoolName) {
        getRedis().set(SmileRedisConst.SMILE_SCHOOL.concat(":").concat(schoolId), schoolName);
    }

    /**
     * 保存全部学校
     */
    public void setSchoolAll(List<SmileSchoolVo> smileSchoolVos) {
        getRedis().set(SmileRedisConst.SMILE_SCHOOL, smileSchoolVos);
    }

    /**
     * 删除缓存学校集合
     */
    public void delSchoolAll() {
        getRedis().del(SmileRedisConst.SMILE_SCHOOL);
    }

    /**
     * 获取全部学校
     */
    public List<SmileSchoolVo> getSchoolAll() {
       return (List<SmileSchoolVo>)getRedis().get(SmileRedisConst.SMILE_SCHOOL);
    }

    /**
     * 删除学校
     */
    public void delSchool(String schoolId) {
        getRedis().del(SmileRedisConst.SMILE_SCHOOL.concat(":").concat(schoolId));
    }

    /**
     * 获取演出打款状态
     */
    public String getShowStatus(String performancesId) {
        return (String) getRedis().get(SmileRedisConst.SMILE_SHOW.concat(performancesId));
    }


    /**
     * 保存用户最新计算数据
     * @param userData
     */
    public void setUserDataByUid(UserData userData, String perId) {
        String key = SmileRedisConst.SELL_USER_DATA.concat(perId).concat(":").concat(userData.getUid());
        getRedis().set(key, userData, 60 * 60 * 24);
    }

    /**
     * 获取用户最新计算数据
     * @param userData
     */
    public UserData getUserDataByUid(String perId,String uid) {
        String key = SmileRedisConst.SELL_USER_DATA.concat(perId).concat(":").concat(uid);
        Object obj = getRedis().get(key);
        if (obj==null){
            return null;
        }else {
            return (UserData)obj;
        }
    }

    /**
     * 保存演出ids
     */
    public void setShowIds(List<String> perId) {
        getRedis().set(SmileRedisConst.SMILE_SHOW, perId);
    }

    /**
     * 获取演出ids
     */
    public List<String> getShowIds(){
        String rdk = SmileRedisConst.SMILE_SHOW;
        Object obj = getRedis().get(rdk);
        if (obj == null) {
            return CollectionUtil.arrayListString();
        } else {
            return (List<String>) obj;
        }
    }

    public void delShow(){
        String rdk = SmileRedisConst.SMILE_SHOW;
        Object obj = getRedis().get(rdk);
        if (obj != null) {
            try {
                List<String> obj1 = (List<String>) obj;
            } catch (Exception e) {
                log.debug("不是新存ids，需要删除！");
                getRedis().del(rdk);

                ArrayList<String> arrayList = CollectionUtil.arrayListString();
                //旧版转换
                String perforManceIds = (String) obj;
                if (StringUtils.isNotBlank(perforManceIds)) {
                    arrayList.addAll(Arrays.asList(perforManceIds.split(",")));
                }
                setShowIds(arrayList);
            }
        }
    }

    /**
     * 保存个人打款
     */
    public void setPriceByUid(String performancesId, String uid) {
        getRedis().set(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId).concat(uid), 0);
    }

    /**
     * 获取个人打款状态
     */
    public Integer getShowPriceUid(String performancesId, String uid) {
        return (Integer) getRedis().get(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId).concat(uid));
    }

    /**
     * 删除个人打款状态
     */
    public void delPriceByUid(String performancesId, String uid) {
        getRedis().del(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId).concat(uid));
    }

    /**
     * 总共演出打款
     */
    public void setShowPriceId(String performancesId) {
        getRedis().set(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId), 0);
    }

    /**
     * 总共演出打款删除
     */
    public void delShowPriceId(String performancesId) {
        getRedis().del(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId));
    }

    /**
     * 获取演出打款状态
     */
    public Integer getShowPriceId(String performancesId) {
        return (Integer) getRedis().get(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId));
    }

    /**
     * 获取用户数据
     */
    public SmileSellDataVO getSellDataVO(String uid, String performancesId) {
        return (SmileSellDataVO) getRedis().get(SmileRedisConst.SELL_DATA.concat(uid).concat(performancesId));
    }

    /**
     * 保存票提
     */
    public void setAgent(String performancesId, String ticketId, SmileAgentVo smileAgentVo) {
        getRedis().set(SmileRedisConst.SMILE_AGENT.concat(performancesId).concat(":").concat(ticketId), smileAgentVo);
    }

    public SmileAgentVo getAgent(String performanceId, String ticketId) {
        return (SmileAgentVo) getRedis().get(SmileRedisConst.SMILE_AGENT.concat(performanceId).concat(":").concat(ticketId));
    }

    /**
     * 删除票提记录
     */
    public void delAgent(String performancesId, String ticketId) {
        getRedis().del(SmileRedisConst.SMILE_AGENT.concat(performancesId).concat(":").concat(ticketId));
    }

    public BigDecimal getUserTotalPrice(String uid) {
        return (getRedis().get(SmileRedisConst.SELL_USER_REVENUE.concat(uid))) == null ? BigDecimal.valueOf(0) : (BigDecimal) redisDataSourceUtil.getRedisSweetUtil().get(SmileRedisConst.SELL_USER_REVENUE.concat(uid));
    }

    public void setUserTotalPrice(String uid, BigDecimal add) {
        getRedis().set(SmileRedisConst.SELL_USER_REVENUE.concat(uid), add);
    }

    // 覆盖活动详情
    public void setProject(String projectId, SmileProjectDetailsVo vo) {
        String rdk = SmileRedisConst.PROJECT_DETAILS.concat(projectId);
        getRedis().set(rdk, vo);
    }

    // 获取活动详情
    public SmileProjectDetailsVo getProject(String projectId) {
        String rdk = SmileRedisConst.PROJECT_DETAILS.concat(projectId);
        Object obj = getRedis().get(rdk);
        if(obj==null){
            return null;
        }else{
            return (SmileProjectDetailsVo) obj;
        }
    }

    // 覆盖职责组详情
    public void setTeam(String teamId, SmileVolunteersTeam vo) {
        String rdk = SmileRedisConst.TEAM_DETAILS.concat(teamId);
        getRedis().set(rdk, vo);
    }

    // 获取活动列表id
    public ArrayList<String> getProjectId() {
        String rdk = SmileRedisConst.PROJECT_ID_LIST;
        Object obj = getRedis().get(rdk);
        if (obj == null) {
            return CollectionUtil.arrayListString();
        } else {
            return (ArrayList<String>) obj;
        }
    }

    // 添加活动列表id
    public void addProjectId(String projectId) {
        String rdk = SmileRedisConst.PROJECT_ID_LIST;
        ArrayList<String> list = getProjectId();
        list.add(projectId);
        if (list.size() > 40) {
            list.remove(0);
        }
        getRedis().set(rdk, list);
    }

    // 添加活动列表id
    public void delProjectId(String projectId) {
        String rdk = SmileRedisConst.PROJECT_ID_LIST;
        ArrayList<String> list = getProjectId();
        System.out.println("list=" + list.toString());
        for (String id : list) {
            if (id.equals(projectId)) {
                list.remove(projectId);
                break;
            }
        }
        getRedis().set(rdk, list);
    }

    /**
     * 添加志愿者报名情况
     *
     * @param projectId 活动id
     * @param uid       用户id
     * @param teamIds   组id数组
     */
    public void setVolunteers(String projectId, String uid, ArrayList<String> teamIds) {
        String rdk = SmileRedisConst.VOLUNTEERS_DETAILS.concat(projectId).concat(":uid:").concat(uid);
        getRedis().set(rdk, teamIds);
    }

    /**
     * 保存演出列表vo
     * @param vo
     */
    public void setShowVoByPerId(ShowVo vo) {
        String key = SmileRedisConst.SELL_SHOW_SAVE.concat(vo.getPerformancesId());
        getRedis().set(key,vo);
    }
    /**
     * 获取演出列表vo
     * @param vo
     */
    public ShowVo getShowVoByPerId(String perId) {
        String key = SmileRedisConst.SELL_SHOW_SAVE.concat(perId);
        Object o = getRedis().get(key);
        if (o==null){
            return null;
        }else {
            return (ShowVo) o;
        }
    }

}
