package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinDigitalArtworkInfoVo", description = "藏品详情信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinDigitalArtworkInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 8903534983251413696L;
    @ApiModelProperty(position = 11, value = "是否盲盒[0-否|1-是]")
    private Integer unbox;

    @ApiModelProperty(position = 12, value = "藏品名称")
    private String name;
    @ApiModelProperty(position = 13, value = "藏品素材类型[1-图片|2-视频|3-模型]")
    private Integer materialType;
    @ApiModelProperty(position = 14, value = "藏品素材URL")
    private String materialUrl;
    @ApiModelProperty(position = 15, value = "序列号")
    private Integer editionSn;
    @ApiModelProperty(position = 16, value = "藏品发行量")
    private Integer edition;
    @ApiModelProperty(position = 17, value = "NFT藏品HASH")
    private String nftHash;
    @ApiModelProperty(position = 18, value = "NFT系列声明时间")
    private String declareAt;

    @ApiModelProperty(position = 19, value = "获得方式[0-购买|1-兑换]")
    private Integer getway;
    @ApiModelProperty(position = 20, value = "藏品状态，根据`unbox`区分盲盒来判断[0-生成中/未开启|1-已生成/已开启|2-生成失败/开启失败]")
    private Integer state;
    @ApiModelProperty(position = 21, value = "创作者")
    private String author;
    @ApiModelProperty(position = 22, value = "收藏者")
    private String collector;
    @ApiModelProperty(position = 23, value = "发行方")
    private String publisher;

    private static final GoblinDigitalArtworkInfoVo obj = new GoblinDigitalArtworkInfoVo();

    public static GoblinDigitalArtworkInfoVo getNew() {
        try {
            return (GoblinDigitalArtworkInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinDigitalArtworkInfoVo();
        }
    }
}
