package com.liquidnet.service.smile.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 志愿者-项目关联职责表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-04-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SmileProjectTeamRelation implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 活动id
     */
    private String projectId;

    /**
     * 职责组id
     */
    private String teamId;

    /**
     * 补充字段
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SmileProjectTeamRelation obj = new SmileProjectTeamRelation();

    public static SmileProjectTeamRelation getNew() {
        try {
            return (SmileProjectTeamRelation) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SmileProjectTeamRelation();
        }
    }
}
