package com.liquidnet.service.platform.service.ticketSystem;

import com.alibaba.fastjson.JSONObject;
import com.liquidnet.service.kylin.dto.vo.ticketSystem.CheckVo;
import com.liquidnet.service.kylin.dto.vo.ticketSystem.STFieldChangeVo;
import com.liquidnet.service.kylin.dto.vo.ticketSystem.STFieldListVo;
import com.liquidnet.service.kylin.dto.vo.ticketSystem.STPTListVo;
import com.liquidnet.service.kylin.dto.param.ticketSystem.*;

import java.util.List;

/**
 * <p>
 * 票务对接平台 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-20
 */
public interface ITicketSystemService {

    /**
     * 获取accessToken
     *
     * @return
     */
    String getAccessToken();

    /**
     * 查询标准演出类型
     *
     * @param accessToken 访问令牌
     * @return
     */
    List<STPTListVo> getPerformanceTypeList(String accessToken);

    /**
     * 查询标准演出场所
     *
     * @param accessToken 访问令牌
     * @return
     */
    List<STFieldListVo> getFieldList(String accessToken, STFieldListParam fieldListParam);

    /**
     * 新增演出场厅
     *
     * @param accessToken 访问令牌
     */
    STFieldChangeVo insertField(String accessToken, STInsertFieldParam insertFieldParam);


    /**
     * 上报演出场次接口
     *
     * @param accessToken 访问令牌
     * @return {
     * "sessionId1":"sessionCode1",
     * "sessionId2":"sessionCode2"
     * }
     */
    JSONObject insertPerformance(String accessToken, STInsertPerformanceParam insertPerformanceParam);


    /**
     * 更新上报的演出项目数据
     *
     * @param accessToken 访问令牌
     */
    boolean updatePerformance(String accessToken, STUpdatePerformanceParam updatePerformanceParam);

    /**
     * 更新上报的场次数据
     *
     * @param accessToken      访问令牌
     * @return
     */
    boolean updateTimes(String accessToken, STUpdateTimesParam updateTimesParam);

    /**
     * 上报票价信息
     *
     * @param accessToken 访问令牌
     * @return
     */
    boolean insertTicketPrice(String accessToken,STInsertTicketPriceParam insertTicketPriceParam );

    /**
     * 删除票价信息
     *
     * @param accessToken   访问令牌
     * @return
     */
    boolean delTicketPrice(String accessToken, STDelTicketPriceParam delTicketPriceParam);

    /**
     * 上报票信息
     *
     * @param accessToken   访问令牌
     * @return
     */
    boolean insertTicket(String accessToken, STInsertTicketParam insertTicketParam);

    /**
     * 删除票信息
     *
     * @param accessToken   访问令牌
     * @return
     */
    boolean delTicket(String accessToken,STDelTicketParam delTicketParam);

    /**
     * 上报订单信息
     *
     * @param accessToken     访问令牌

     * @return
     */
    boolean insertOrder(String accessToken, STInsertOrderParam insertOrderParam);
    /**
     * 上报退票信息
     *
     * @param accessToken     访问令牌
     * @return
     */
    boolean refundOrder(String accessToken, STRefundOrderParam refundOrderParam);
    /**
     * 上报检票数据
     *
     * @param accessToken 访问令牌
     * @param ticketList  票信息List
     * @return
     */
    boolean insertCheck(String accessToken, List<CheckVo> ticketList);
}
