package com.liquidnet.service.candy.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.dto.CandyCouponInfoDto;
import com.liquidnet.service.candy.util.ObjectUtil;
import com.liquidnet.service.candy.util.RedisDataUtils;
import com.liquidnet.service.candy.vo.CandyCouponBasicVo;
import com.liquidnet.service.candy.vo.CandyCouponPreviewVo;
import com.liquidnet.service.candy.vo.CandyCouponVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

@Api(tags = "@API:RSC")
@RestController
@Validated
@RequestMapping("rsc")
public class CandyRscController {
    @Autowired
    private RedisDataUtils redisDataUtils;

    @PostMapping("couinfo")
    @ApiOperation("券基础详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "couponIds", value = "券ID，多个以,分割", required = true),
    })
    public ResponseDto<List<CandyCouponPreviewVo>> couponListById(@RequestParam("couponIds") @NotNull @NotBlank String couponIds) {
        String[] couponIdArr = couponIds.split(",");
        ArrayList<CandyCouponPreviewVo> vos = ObjectUtil.getCandyCouponPreviewVoArrayList();
        for (String couponId : couponIdArr) {
            CandyCouponPreviewVo couponBasicVo = CandyCouponPreviewVo.getNew();
            CandyCouponInfoDto couponInfoDto = redisDataUtils.getCouponInfo(couponId);

            if (null == couponInfoDto) continue;

            BeanUtils.copyProperties(couponInfoDto, couponBasicVo);

            vos.add(couponBasicVo);
        }
        return ResponseDto.success(vos);
    }
}
