package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 城市投票表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-09-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetCityVote implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * vote_id
     */
    private String voteId;

    /**
     * 手机号
     */
    private String phone;

    /**
     * openId
     */
    @TableField("openId")
    private String openId;

    /**
     * unionId
     */
    @TableField("unionId")
    private String unionId;

    /**
     * 活动类型 1新裤子 2莫宰羊
     */
    private Integer type;

    /**
     * 城市代码
     */
    private String cityCode;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 投票天
     */
    private String dayTime;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetCityVote obj = new SweetCityVote();
    public static SweetCityVote getNew() {
        try {
            return (SweetCityVote) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetCityVote();
        }
    }

}
