package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 数字藏品信息
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinDigitalArtwork implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 藏品ID
     */
    private String artworkId;

    /**
     * 单品ID
     */
    private String skuId;

    /**
     * 用户UID
     */
    private String uid;

    /**
     * 藏品订单号
     */
    private String orderId;

    /**
     * 序列号
     */
    private Integer editionSn;

    /**
     * 藏品NFT ID
     */
    private String nftId;

    /**
     * 藏品HASH
     */
    private String nftHash;

    /**
     * 发行HASH
     */
    private String releaseTxhash;

    /**
     * 发行时间
     */
    private String releaseAt;

    /**
     * 交易HASH
     */
    private String tradingTxhash;

    /**
     * 交易时间
     */
    private String tradingAt;

    /**
     * 获得方式[1-购买|2-兑换|3-赠送|5-受赠]
     */
    private Integer source;

    /**
     * 藏品状态[0-生成中/未开启|1-已生成/已开启|2-生成失败/开启失败]
     */
    private Integer state;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private String delFlg;

    /**
     * 盲盒开启时间
     */
    private LocalDateTime openingAt;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private LocalDateTime deletedAt;

    private String comment;


}
