package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商城订单表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinStoreOrder implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 店铺id
     */
    private String storeId;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 主订单code  下单可能会同时下多个订单 
     */
    private String masterOrderCode;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 支付单号
     */
    private String payCode;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 用户昵称
     */
    private String userName;

    /**
     * 用户手机号
     */
    private String userMobile;

    /**
     * 应付金额
     */
    private BigDecimal priceTotal;

    /**
     * 实付金额
     */
    private BigDecimal priceActual;

    /**
     * 退款价格
     */
    private BigDecimal priceRefund;

    /**
     * 预售价格
     */
    private BigDecimal preSalePrice;

    /**
     * 快递价格
     */
    private BigDecimal priceExpress;

    /**
     * 管理员修改优惠金额
     */
    private BigDecimal priceModify;

    /**
     * 积分优惠金额
     */
    private BigDecimal pricePoint;

    /**
     * 券优惠金额
     */
    private BigDecimal priceCoupon;

    /**
     * 红包优惠金额
     */
    private BigDecimal priceRedEnvelope;

    /**
     * 总优惠价格
     */
    private BigDecimal priceVoucher;

    /**
     * 订单状态[0-待付款(用户刚下单)|2-代发货(用户付完款 等待商城发货)3-代收货(商城已经发货 等待用户确认收货)|4-已完成(用户已经确认收货 订单结束)|5-取消订单(用户未付款前取消订单)|6-退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)|7-退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)]
     */
    private Integer status;

    /**
     * 正在下单是否出货[0-未出货|1-已出货]
     */
    private Integer zhengzaiStatus;
    /**
     * 预售订单状态[0-第一阶段未支付|1-第一阶段支付第二阶段未支付|3-第二阶段支付]
     */
    private Integer statusPreSale;

    /**
     * 评价状态[0-未评价|1-已评价]
     */
    private Integer statusEvaluation;

    /**
     * 红包code
     */
    private String redEnvelopeCode;

    /**
     * 券id
     */
    private String ucouponId;

    /**
     * 使用积分数
     */
    private BigDecimal usePoint;

    /**
     * 支付类型[wepay-微信支付|alipay-阿里支付|douyinpay-抖音支付|unionpay-银联支付]
     */
    private String payType;

    private String paymentType;
    private String paymentId;
    /**
     * 支付来源
     */
    private String deviceFrom;
    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 是否存在预付款[0-不存在|1-存在]
     */
    private Integer preDepositPay;

    /**
     * 订单来源[app|h5|applet]
     */
    private String source;

    /**
     * 版本号
     */
    private String version;

    /**
     * 是否会员
     */
    private Integer isMember;

    /**
     * 订单类型[0-普通订单|1-定金预售订单|2-全款预售订单|3-拼团订单|4-众筹全款|5-众筹1元|6-众筹无回报|7-虚拟商品订单|8-社区团购订单|9-正在下单]
     */
    private Integer orderType;

    /**
     * 支付时间
     */
    private LocalDateTime payTime;

    /**
     * 取消时间
     */
    private LocalDateTime cancelTime;

    /**
     * 管理员修改订单时间
     */
    private LocalDateTime modifyTime;

    /**
     * 评价时间
     */
    private LocalDateTime evaluationTime;

    /**
     * 预售订单的时间[对于定金预售则是第二阶段付款时间和发货时间|对于全款预售则是发货时间]
     */
    private LocalDateTime preSaleTime;

    /**
     * 订单推广人的会员id(订单会员的推广人 ，也就是订单会员的上级的id) 如果为' 则说明该订单会员没有推荐人或者不是推广订单
     */
    private String recommendedId;

    /**
     * 订单二级推广人的会员id(订单会员的二级推广人 ，也就是订单会员的上级的上级会员id) 如果为' 则说明该订单会员没有推荐人或者不是推广订单
     */
    private String sRecommendedId;

    /**
     * 众筹id
     */
    private String crowdfundingId;

    /**
     * 抽奖状态[0-未抽奖|1-中奖|2-已抽奖]
     */
    private String lotteryStatus;

    /**
     * 虚拟订单核销码[正在支付取货码]
     */
    private String writeOffCode;

    /**
     * 钱到了哪个支付平台  平台的订单id为'
     */
    private String payStoreId;

    /**
     * 订单过期时间(分钟)
     */
    private Integer payCountdownMinute;

    /**
     * ip地址
     */
    private String ipAddress;

    /**
     * ip地域全名称
     */
    private String area;

    /**
     * ip地域省
     */
    private String areaProvince;

    /**
     * ip地域市
     */
    private String areaCity;

    /**
     * ip地域县
     */
    private String areaCounty;

    /**
     * 快递单号
     */
    private String mailNo;

    /**
     * 发货时间
     */
    private LocalDateTime deliveryTime;

    /**
     * 物流公司姓名
     */
    private String logisticsCompany;

    /**
     * 物流公司code[物流公司id]
     */
    private String logisticsCode;

    /**
     * 活动类型
     */
    private String marketType;

    /**
     * 活动id
     */
    private String marketId;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;

    private static final GoblinStoreOrder obj = new GoblinStoreOrder();

    public static GoblinStoreOrder getNew() {
        try {
            return (GoblinStoreOrder) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreOrder();
        }
    }
}
