package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商城用户券信息
 * </p>
 *
 * @author liquidnet
 * @since 2022-02-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinUserCoupon implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String ucouponId;

    /**
     * ~goblin_store_coupon.store_coupon_id
     */
    private String storeCouponId;

    /**
     * ~adam_user.uid
     */
    private String uid;

    /**
     * 用户券状态[1-可用|2-无效|3-已过期|5-已使用]
     */
    private Integer state;

    /**
     * 激活时间
     */
    private LocalDateTime bindAt;

    /**
     * 到期时间
     */
    private LocalDateTime duedAt;

    /**
     * 使用时间
     */
    private LocalDateTime usedAt;

    /**
     * 用于记录购买的内容
     */
    private String usedBy;

    private String operator;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
