package com.liquidnet.service.platform.service.impl.adam.sync.processor;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.liquidnet.service.adam.dto.vo.AdamMemberCodeVo;
import com.liquidnet.service.adam.dto.vo.AdamMemberPriceVo;
import com.liquidnet.service.adam.dto.vo.AdamMemberSimpleVo;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.entity.AdamMemberCode;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.adam.mapper.AdamMemberCodeMapper;
import com.liquidnet.service.adam.mapper.AdamMemberMapper;
import com.liquidnet.service.adam.mapper.AdamMemberPriceMapper;
import com.liquidnet.service.platform.service.impl.adam.sync.SyncDataProcessorService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class SyncMemberRelatedProcessor extends SyncDataProcessorService {
    @Autowired
    AdamMemberMapper memberMapper;
    @Autowired
    AdamMemberPriceMapper memberPriceMapper;
    @Autowired
    AdamMemberCodeMapper memberCodeMapper;

    @Override
    public void dataProcessing(int stp) {
        switch (stp) {
            case 1:
                this.memberHandler();
                break;
            case 2:
                this.memberPriceHandler();
                break;
            case 3:
                this.memberCodeHandler();
                break;
            default:
                log.warn("Invalid operation[stp:{}]", stp);
                break;
        }
    }

    private void memberHandler() {
        List<AdamMember> dtos = memberMapper.selectList(Wrappers.lambdaQuery(AdamMember.class).eq(AdamMember::getState, 1));
        int size = 0, pct = 0;
        if (CollectionUtils.isNotEmpty(dtos)) {
            size = dtos.size();
            log.info("Sync.processing.begin:{}", size);
            for (int i = 0; i < size; i++) {
                AdamMember dto = dtos.get(i);

                AdamMemberVo vo = AdamMemberVo.getNew().copy(dto);
                //log.info("vo:{}", JsonUtils.toJson(vo));
                AdamMemberSimpleVo simpleVo = AdamMemberSimpleVo.getNew().copy(vo);
                //log.info("simpleVo:{}", JsonUtils.toJson(simpleVo));

                dmRdmService.setMemberVoByMemberId(vo.getMemberId(), vo);
                dmRdmService.setMemberSimpleVo(AdamMemberSimpleVo.getNew().copy(vo));

                pct++;
            }
        }
        log.info("Sync.processing.end:{} ~ {}", size, pct);
    }

    private void memberPriceHandler() {
        List<AdamMemberPrice> dtos = memberPriceMapper.selectList(Wrappers.lambdaQuery(AdamMemberPrice.class).eq(AdamMemberPrice::getState, 1));
        int size = 0, pct = 0;
        if (CollectionUtils.isNotEmpty(dtos)) {
            size = dtos.size();
            log.info("Sync.processing.begin:{}", size);
            for (int i = 0; i < size; i++) {
                AdamMemberPrice dto = dtos.get(i);

                AdamMemberPriceVo vo = AdamMemberPriceVo.getNew().copy(dto);
                //log.info("vo:{}", JsonUtils.toJson(vo));

                List<AdamMemberPriceVo> vos = dmRdmService.getMemberPriceVoByMemberId(dto.getMemberId());
                if (null == vos) {
                    vos = new ArrayList<>();
                }
                vos.add(vo);
                dmRdmService.setMemberPriceVoByMemberId(vo.getMemberId(), vos);

                pct++;
            }
        }
        log.info("Sync.processing.end:{} ~ {}", size, pct);
    }

    private void memberCodeHandler() {
        LambdaQueryWrapper<AdamMemberCode> lambdaQueryWrapper =
                Wrappers.lambdaQuery(AdamMemberCode.class).eq(AdamMemberCode::getState, 0)
                        .orderByDesc(AdamMemberCode::getMid);
        Integer totalCount = memberCodeMapper.selectCount(lambdaQueryWrapper);
        int totalRows = null == totalCount ? 0 : totalCount, nth = 0, offset = 5000, pct = 0;
        log.info("Sync.processing.begin:{}/{}, {} ~ {}", totalCount, offset, nth, pct);


        while (totalRows > 0) {
            int rows = nth * offset;
            log.info("Sync.processing.limit {},{} - {} begin", rows, offset, nth);


            PageHelper.startPage(nth + 1, offset);
            List<AdamMemberCode> dtos = memberCodeMapper.selectList(lambdaQueryWrapper);
            if (!CollectionUtils.isEmpty(dtos)) {
                int size = dtos.size();
                for (int i = 0; i < size; i++) {
                    AdamMemberCode dto = dtos.get(i);

                    AdamMemberCodeVo vo = AdamMemberCodeVo.getNew().copy(dto);
                    //log.info("vo:{}", JsonUtils.toJson(vo));

                    dmRdmService.setMemberCodeVoByCode(dto.getCode(), vo);

                    pct++;
                }
            }


            log.info("Sync.processing.limit {},{} - {} handle.counts:{}", rows, offset, nth, pct);
            nth++;
            totalRows -= offset;
        }


        log.info("Sync.processing.end:{} / {},{} ~ {}", totalCount, nth, offset, pct);
    }
}
