package com.liquidnet.service.feign.adam.api;

import com.liquidnet.service.adam.dto.rsc.AdamChimeUinfoDto;
import com.liquidnet.service.adam.dto.vo.*;
import com.liquidnet.service.adam.dto.rsc.AdamChimeUinfoReq;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;

@Component
@FeignClient(name = "liquidnet-service-adam",
        contextId = "FeignAdamBaseClient", path = "adam",
        url = "${liquidnet.service.adam.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignAdamBaseClient {

    /**
     * 不推荐使用，建议使用`rsc/inquire/enters`
     */
    @GetMapping("enters/query/depth")
    ResponseDto<AdamEntersVo> queryEnters(@RequestParam("entersId") String entersId,
                                          @RequestParam("uid") String uid);

    @GetMapping("addr/query/depth")
    ResponseDto<AdamAddressesVo> queryAddresses(@RequestParam(value = "addrId") String addrId,
                                                @RequestParam(value = "uid") String uid);

    /* -------------------------------------------------------------------- */

    @PostMapping("rsc/inquire/cuinfo")
    ResponseDto<List<AdamChimeUinfoDto>> queryForChimeUserInfo(@RequestBody AdamChimeUinfoReq req);

    @PostMapping("rsc/inquire/sendMsgToRedis")
    ResponseDto<Boolean> sendMsgToRedis(@RequestParam("redisKey") String redisKey, @RequestParam("jsonParamStr") String jsonParamStr);

    @PostMapping(value = {"rsc/reg/mobile"})
    ResponseDto<AdamUserInfoVo> registerByMobile(@Pattern(regexp = "\\d{11}", message = "手机号格式有误")
                                                 @RequestParam(value = "mobile") String mobile);

    /**
     * 入场人信息查取
     *
     * @param entersIds List<String>:入场人ID集合
     * @param uid       用户ID
     * @return ResponseDto<List < AdamEntersVo>>
     */
    @GetMapping("rsc/inquire/enters")
    ResponseDto<List<AdamEntersVo>> querysEnters(@NotNull(message = "入场人ID不能为空") @RequestParam(value = "entersIds") List<String> entersIds,
                                                    @NotBlank(message = "用户ID不能为空") @RequestParam(value = "uid") String uid);

    @GetMapping("rsc/inquire/member")
    ResponseDto<AdamUserMemberVo> queryMember(@NotBlank(message = "用户ID不能为空") @RequestParam(value = "uid") String uid);

    /* -------------------------------------------------------------------- */

    @PostMapping(value = {"login/silent_mobile"})
    ResponseDto<AdamLoginInfoVo> loginBySilentMobile(@Pattern(regexp = "\\d{11}", message = "手机号格式有误")
                                                     @NotBlank(message = "手机号不能为空")
                                                     @RequestParam(value = "mobile") String mobile,
                                                     @NotBlank(message = "临时票据不能为空")
                                                     @RequestParam(value = "otp") String otp);

    @GetMapping(value = "member/check/depth", headers = {"Inner-Required=1"})
    ResponseDto<Boolean> isMember(@NotBlank(message = "用户ID不能为空") @RequestParam(value = "uid") String uid);

    @GetMapping(value = "user/info/rds")
    ResponseDto<AdamUserInfoVo> getAdamUserInfoByUid(@NotBlank(message = "Uid不能为空") @RequestParam(value = "uid") String uid);
}
