package com.liquidnet.client.admin.web.controller.zhengzai.goblin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.goblin.utils.GoblinRedisUtils;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.vo.CandyCouponVo;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyReqDto;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "商铺公共方法")
@Controller
@RequestMapping("goblin/gago")
public class GoblinGagoController extends BaseController {

    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
        @Value("${liquidnet.service.order.url}")
    private String orderUrl;
//    private String orderUrl = "http://127.0.0.1:9004/order";

    private final String prefix = "zhengzai/goblin/gago";

    @GetMapping()
    public String mainHtml() {
        return prefix + "/gago";
    }

    @Log(title = "判断手机号是否开通数字账号", businessType = BusinessType.INNER_OPERATION)
    @GetMapping("nftAccount")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, name = "userMobile", value = "手机号"),
    })
    @ResponseBody
    public AjaxResult storeSearch(String userMobile) {
        AjaxResult ajaxResult = AjaxResult.success();
        Object obj1 = redisDataSourceUtil.getRedisAdamUtil().get(AdamRedisConst.IDENTITY_MOBILE.concat(userMobile));
        if (obj1 == null) {
            return AjaxResult.error("账号不存在");
        }
        String uid = (String) obj1;
        Boolean obj2 = goblinRedisUtils.getIsOpenAccount(uid);
        if (!obj2) {
            return AjaxResult.error("账号未开通数字账号");
        }
        ajaxResult.put("uid", uid);
        return ajaxResult;
    }


    @Log(title = "生成兑换订单", businessType = BusinessType.INNER_OPERATION)
    @PostMapping(value = "/exchangeNumNftOrder")
    @ResponseBody
    public AjaxResult listByStatus(@RequestParam(value = "skuId") String skuId, @RequestParam(value = "nftNum") int nftNum, @RequestParam(value = "uid") String uid) {
        //当前 nft序号
        GoblinGoodsSkuInfoVo skuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(skuId);
        int cNufCount = goblinRedisUtils.getNftCountBySku(skuInfoVo.getRouteType(), skuId);
        if (cNufCount >= nftNum) {
            return AjaxResult.error("该序号已售卖");
        }
        if (skuInfoVo == null || skuInfoVo.getSkuStock() <= nftNum) {
            return AjaxResult.error("该序号不存在");
        }
        if (skuInfoVo.getUnbox().equals("1")) {
            return AjaxResult.error("不支持盲盒");
        }
        boolean addResult = goblinRedisUtils.addNftList(skuId, nftNum + "");
        if (!addResult) {
            return AjaxResult.error("该序号已被占用");
        }
        //
        int count = goblinRedisUtils.decrSkuStock(null,skuId,1);
        if(count<0){
            goblinRedisUtils.incrSkuStock(null,skuId,1);
            goblinRedisUtils.removeNftList(skuId, nftNum + "");
            return AjaxResult.error("已售罄");
        }

        //下单
        MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
        params.add("userId", uid);
        params.add("skuId", skuId);
        MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
        header.add("Accept", "application/json;charset=UTF-8");
        System.out.println(orderUrl.concat("/goblin/nft/airdropInner"));
        String returnData = HttpUtil.post(orderUrl.concat("/order/goblin/nft/airdropInner"), params, header);
        ResponseDto<String> innerReturnVo = JsonUtils.fromJson(returnData, new TypeReference<ResponseDto<String>>() {
        });
        if (innerReturnVo.isSuccess()) {
            GalaxyNftPublishAndBuyReqDto dto = GalaxyNftPublishAndBuyReqDto.getNew();
            dto.setBuyTimestamp(DateUtil.getNowTime());
            dto.setNftOrderPayId(innerReturnVo.getData());
            dto.setSkuId(skuId);
            dto.setUserId(uid);
            goblinRedisUtils.setNftNumDetails(nftNum + "", skuId, dto);
            return AjaxResult.success();
        } else {
            return AjaxResult.error();
        }
    }

    /** ------------------------------------------------------------------------ **/
}
