package com.liquidnet.service.kylin.constant;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 限购对象枚举
 */
@ApiModel("限购对象枚举")
public enum LimitTargetEnum {

    @ApiModelProperty("账户")
    ACCOUNT(1, "账户"),

    @ApiModelProperty("实名")
    IDCARD(2, "实名");

    private final int code;
    private final String desc;

    LimitTargetEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static LimitTargetEnum valueOf(int code) {
        for (LimitTargetEnum target : values()) {
            if (target.code == code) {
                return target;
            }
        }
        return null;
    }
}