package com.liquidnet.service.kylin.dto.param;

import com.liquidnet.service.kylin.entity.KylinBuyNotice;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 购票须知参数
 *
 * @author system
 * @since 2026-01-19
 */
@Data
@ApiModel("购票须知参数")
public class BuyNoticeParam {

    @ApiModelProperty(value = "须知ID")
    private String buyNoticeId;

    @ApiModelProperty(value = "须知图片")
    private String imgUrl;

    @ApiModelProperty(value = "须知标题")
    private String title;

    @ApiModelProperty(value = "须知内容")
    private String message;

    @ApiModelProperty(value = "排序权重")
    private Integer sort;

    @ApiModelProperty(value = "须知类型 1购票须知 2观演须知")
    private Integer noticeType;

    @ApiModelProperty(value = "状态 0禁用 1启用")
    private Integer status;

    @ApiModelProperty(value = "批量操作的ID列表")
    private List<String> ids;

    public KylinBuyNotice getFields(String buyNoticeId, LocalDateTime createdAt) {
        KylinBuyNotice kylinBuyNotice = new KylinBuyNotice();
        BeanUtils.copyProperties(this, kylinBuyNotice);
        
        if (buyNoticeId != null) {
            kylinBuyNotice.setBuyNoticeId(buyNoticeId);
        }
        if (createdAt != null) {
            kylinBuyNotice.setCreatedAt(createdAt);
        }
        kylinBuyNotice.setUpdatedAt(LocalDateTime.now());
        
        return kylinBuyNotice;
    }
}