package com.liquidnet.service.platform.controller.A_fskfsfs.diagnostic.vo;

import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;

import java.util.List;

@Data
public class PerformanceDiagnosticVo implements Serializable {
    private String performanceId;
    private String title;
    private Integer auditStatus; // Partner view
    private Integer mongoStatus; // Mongo Status (Synced)
    private Integer mysqlStatus; // Critical: Real status in MySQL
    private String merchantId;

    // Diagnostic flags
    private boolean isPerformanceOnline; // MySQL status == 9?
    private boolean isPerformanceConnectable; // Can user access?

    private List<SessionDiagnosticVo> sessions;

    @Data
    public static class SessionDiagnosticVo implements Serializable {
        private String timesId;
        private String performanceId;
        private String title;
        private String useStart;
        private String useEnd;
        private Integer status; // Mongo status

        private List<TicketDiagnosticVo> tickets;
    }

    @Data
    public static class TicketDiagnosticVo implements Serializable {
        private String ticketsId;
        private String title;
        private BigDecimal price;

        // MongoDB Data
        private Integer mongoStatus; // Partner view status
        private String saleTimeStart;
        private String saleTimeEnd;
        private String createdAt;
        private Integer viewersNumber;

        // MySQL Data (The Truth)
        private Integer mysqlStatus;

        // Computed Diagnostic Status
        private boolean isOnline; // mysqlStatus == 9
        private boolean isDeleted; // mysqlStatus == -1?

        // Capabilities & Reasons
        private boolean canDelete;
        private String cannotDeleteReason;

        private boolean canEdit;
        private String cannotEditReason;

        private boolean isVisibleToUser; // isOnline && Performance.isOnline
        private String notVisibleReason;

        private boolean isSaleable; // Time valid && Visible
        private String notSaleableReason;
    }
}
