package com.liquidnet.service.merchant.service;

import com.liquidnet.service.merchant.dto.vo.MerchantFieldsVo;
import com.liquidnet.service.merchant.dto.vo.MerchantSponsorsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class MerchantMongoService {
    @Autowired
    private MongoTemplate mongoTemplate;

    public MerchantFieldsVo getMerchantFieldsVoByFieldId(String fieldId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("fieldId").is(fieldId)), MerchantFieldsVo.class, MerchantFieldsVo.class.getSimpleName());
    }

    public MerchantSponsorsVo getMerchantSponsorsVoBySponsorId(String sponsorId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("sponsorId").is(sponsorId)), MerchantSponsorsVo.class, MerchantSponsorsVo.class.getSimpleName());
    }
}
