package com.liquidnet.service.merchant.service.impl;

import com.liquidnet.service.merchant.dto.vo.MerchantFieldAppliesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantSponsorAppliesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantStationsVo;
import com.liquidnet.service.merchant.service.IMerchantStationsService;
import com.liquidnet.service.merchant.service.MerchantRdmService;
import com.liquidnet.service.merchant.util.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.List;

@Slf4j
@Service
public class MerchantStationsServiceImpl implements IMerchantStationsService {

    @Autowired
    MerchantRdmService merchantRdmService;

    @Override
    public List<MerchantStationsVo> stationsList(String uid) {

        List<MerchantStationsVo> vos = ObjectUtil.getMerchantStationsVosArrayList();

        List<MerchantFieldAppliesVo> fieldAppliesVos = merchantRdmService.getFieldAppliesVosByUid(uid);
        if (!CollectionUtils.isEmpty(fieldAppliesVos)) {
            for (MerchantFieldAppliesVo fieldAppliesVo : fieldAppliesVos) {
                MerchantFieldAppliesVo appliesVo = MerchantFieldAppliesVo.getNew();
                appliesVo.setFieldApplyId(fieldAppliesVo.getFieldApplyId());
                appliesVo.setApplyStatus(fieldAppliesVo.getApplyStatus());
                appliesVo.setApplyType(fieldAppliesVo.getApplyType());
                appliesVo.setReject(fieldAppliesVo.getReject());
                appliesVo.setUid(fieldAppliesVo.getUid());
                appliesVo.setFieldId(fieldAppliesVo.getFieldId());
                appliesVo.setName(fieldAppliesVo.getName());
                appliesVo.setLogo(fieldAppliesVo.getLogo());
                appliesVo.setBackground(fieldAppliesVo.getBackground());
                appliesVo.setDescription(fieldAppliesVo.getDescription());
                appliesVo.setBuiltDate(fieldAppliesVo.getBuiltDate());
                appliesVo.setCreatedAt(fieldAppliesVo.getCreatedAt());
                appliesVo.setUpdatedAt(fieldAppliesVo.getUpdatedAt());
                appliesVo.setDeletedAt(fieldAppliesVo.getDeletedAt());

                MerchantStationsVo vo = MerchantStationsVo.getNew();
                vo.setStationType("field");
                vo.setFieldAppliesVo(appliesVo);
                vo.setCreatedAt(appliesVo.getCreatedAt());
                vo.setUpdatedAt(appliesVo.getUpdatedAt());
                vo.setDeletedAt(appliesVo.getDeletedAt());
                vos.add(vo);
            }
        }

        List<MerchantSponsorAppliesVo> sponsorAppliesVos = merchantRdmService.getSponsorAppliesVosByUid(uid);
        if (!CollectionUtils.isEmpty(sponsorAppliesVos)) {
            for (MerchantSponsorAppliesVo sponsorAppliesVo : sponsorAppliesVos) {
                MerchantSponsorAppliesVo appliesVo = MerchantSponsorAppliesVo.getNew();
                appliesVo.setSponsorApplyId(sponsorAppliesVo.getSponsorApplyId());
                appliesVo.setApplyStatus(sponsorAppliesVo.getApplyStatus());
                appliesVo.setApplyType(sponsorAppliesVo.getApplyType());
                appliesVo.setReject(sponsorAppliesVo.getReject());
                appliesVo.setUid(sponsorAppliesVo.getUid());
                appliesVo.setName(sponsorAppliesVo.getName());
                appliesVo.setLogo(sponsorAppliesVo.getLogo());
                appliesVo.setBackground(sponsorAppliesVo.getBackground());
                appliesVo.setDescription(sponsorAppliesVo.getDescription());
                appliesVo.setCreatedAt(sponsorAppliesVo.getCreatedAt());
                appliesVo.setUpdatedAt(sponsorAppliesVo.getUpdatedAt());
                appliesVo.setDeletedAt(sponsorAppliesVo.getDeletedAt());

                MerchantStationsVo vo = MerchantStationsVo.getNew();
                vo.setStationType("sponsor");
                vo.setSponsorAppliesVo(appliesVo);
                vo.setCreatedAt(appliesVo.getCreatedAt());
                vo.setUpdatedAt(appliesVo.getUpdatedAt());
                vo.setDeletedAt(appliesVo.getDeletedAt());
                vos.add(vo);
            }
        }

        vos.sort(Comparator.comparing(MerchantStationsVo::getCreatedAt).reversed());

        return vos;
    }
}
