package com.liquidnet.service.goblin.controller.Inner;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.impl.inner.GoblinNftJobServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "@API:RSC")
@RestController
@Validated
@RequestMapping("/rsc/nft/job")
public class GoblinNftJobController {

    @Autowired
    GoblinNftJobServiceImpl goblinNftJobService;

    @GetMapping("goodsList")
    @ApiOperation("NFT商品列表JOB")
    public ResponseDto<Boolean> getGoodsList() {
        return goblinNftJobService.goodsList();
    }

    @GetMapping("goblinNftListStock")
    @ApiOperation("处理[未开售/开售]五分钟内的nft[优先购/分批购]库存job ")
    public ResponseDto<Boolean> goblinNftListStock() {
        return goblinNftJobService.goblinNftListStock();
    }

}
