package com.liquidnet.service.candy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 券适用关联配置
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CandyCouponRelate implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * ~candy_coupon.coupon_id
     */
    private String couponId;

    /**
     * 适用ID
     */
    private String busiId;

    /**
     * 适用范围[1-巡演]
     */
    private Integer scope;

    /**
     * [0-INIT|1-NORMAL|2-INVALID]
     */
    private Integer state;

    /**
     * 操作人
     */
    private String operator;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
