package com.liquidnet.client.admin.web.controller.zhengzai.sweet;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetIntegralActivityService;
import com.liquidnet.service.sweet.dto.param.admin.SweetIntegralActivityFromParam;
import com.liquidnet.service.sweet.dto.param.admin.SweetIntegralActivityListSearchParam;
import com.liquidnet.service.sweet.dto.vo.admin.SweetIntegralActivityVo;
import com.liquidnet.service.sweet.entity.SweetIntegralActivity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 积分活动表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */
@Api(tags = "积分活动管理")
@RestController
@RequestMapping("/sweetIntegralActivity")
public class SweetIntegralActivityController extends BaseController {
    private String prefix = "zhengzai/sweet/integralActivity";

    @Autowired
    private ISweetIntegralActivityService iSweetIntegralActivityService;

    @GetMapping("listView")
    @ApiOperation(value = "积分活动列表view")
    public String listView() {
        return prefix + "/list";
    }

    @GetMapping("formView")
    @ApiOperation(value = "积分活动添加编辑view")
    public String formView () {
        return prefix + "/form";
    }

    @Log(title = "积分活动列表数据", businessType = BusinessType.LIST)
    @RequiresPermissions("admin:sweetIntegralActivity:list")
    @ApiOperation(value = "积分活动列表数据")
    @GetMapping("list")
    @ResponseBody
    public TableDataInfo list(SweetIntegralActivityListSearchParam listParam) {
        PageInfo<SweetIntegralActivity> result = iSweetIntegralActivityService.list(listParam);
        return getDataTable(result.getList());
    }

    @Log(title = "积分活动上下线", businessType = BusinessType.UPDATE)
    @RequiresPermissions("admin:sweetIntegralActivity:isOnline")
    @ApiOperation(value = "积分活动上下线")
    @PutMapping("isOnline")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "integralActivityId", value = "活动id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "isOnline", value = "是否上线 1下线 2上线"),
    })
    public AjaxResult isOnline(@RequestParam("integralActivityId") String integralActivityId, @RequestParam("isOnline") Integer isOnline) {
        Integer result = iSweetIntegralActivityService.isOnline(integralActivityId, isOnline);
        if (result > 0) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    @Log(title = "积分活动详情", businessType = BusinessType.DETAIL)
    @GetMapping("details")
    @ApiOperation(value = "积分活动详情")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", required = true, dataType = "String", name = "integralActivityId", value = "活动id"),
    })
    public AjaxResult details(@RequestParam("integralActivityId") String integralActivityId) {
        SweetIntegralActivityVo result = iSweetIntegralActivityService.detail(integralActivityId);
        return AjaxResult.success(result);
    }

    @Log(title = "积分活动创建", businessType = BusinessType.INSERT)
    @PostMapping("")
    @ApiOperation(value = "积分活动创建")
    @ResponseBody
    public AjaxResult create(SweetIntegralActivityFromParam param) {
        Integer result = iSweetIntegralActivityService.createForm(param);
        if (result > 0) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    @Log(title = "积分活动编辑", businessType = BusinessType.UPDATE)
    @PutMapping("")
    @ApiOperation(value = "积分活动编辑")
    @ResponseBody
    public AjaxResult update(SweetIntegralActivityFromParam param) {
        Integer result = iSweetIntegralActivityService.updateForm(param);
        if (result > 0) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
}
