package com.liquidnet.client.admin.zhengzai.stone.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.stone.service.IScoreService;
import com.liquidnet.client.admin.zhengzai.stone.service.vo.StoneUserScoreDetailVo;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.stone.dto.StoneScoreListDto;
import com.liquidnet.service.stone.entity.StoneScoreLogs;
import com.liquidnet.service.stone.entity.StoneScoreUser;
import com.liquidnet.service.stone.mapper.StoneScoreLogsMapper;
import com.liquidnet.service.stone.mapper.StoneScoreUserMapper;
import com.liquidnet.service.stone.param.StoneScoreListParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;


@Service
@Slf4j
public class ScoreServiceImpl implements IScoreService {

    @Autowired
    StoneScoreUserMapper stoneScoreUserMapper;
    @Autowired
    StoneScoreLogsMapper stoneScoreLogsMapper;

    @Override
    public PageInfo<StoneScoreListDto> list(StoneScoreListParam param) {
        PageInfo<StoneScoreListDto> pageInfo;
        param.setUid("-999");
        List<StoneScoreListDto> dto = stoneScoreUserMapper.list(param);
        pageInfo = new PageInfo(dto);
        return pageInfo;
    }

    @Override
    public String changeStatus(String uid, Integer status) {
        if(!(status==1 || status==2)){
            return "状态错误";
        }
        StoneScoreUser data = new StoneScoreUser();
        data.setStatus(status);
        int isExists = stoneScoreUserMapper.selectCount(Wrappers.lambdaQuery(StoneScoreUser.class).eq(StoneScoreUser::getUid, uid));
        int count = 0;
        if (isExists > 0) {
            data.setUpdatedAt(LocalDateTime.now());
            count = stoneScoreUserMapper.update(data, Wrappers.lambdaQuery(StoneScoreUser.class).eq(StoneScoreUser::getUid, uid));
        } else {
            data.setScoreId(IDGenerator.nextTimeId2());
            data.setUid(uid);
            data.setCreatedAt(LocalDateTime.now());
            count = stoneScoreUserMapper.insert(data);
        }
        if (count <= 0) {
            return "修改失败";
        }
        return "修改成功";
    }

    @Override
    public StoneUserScoreDetailVo userScoreDetail(String uid) {
        StoneScoreListParam param = new StoneScoreListParam();
        param.setMobile("");
        param.setStatus(-999);
        param.setUid(uid);
        List<StoneScoreListDto> dto = stoneScoreUserMapper.list(param);
        List<StoneScoreLogs> dataList = stoneScoreLogsMapper.selectList(Wrappers.lambdaQuery(StoneScoreLogs.class).eq(StoneScoreLogs::getUid, uid));
        StoneUserScoreDetailVo vo = new StoneUserScoreDetailVo();
        vo.setDto(dto.get(0));
        vo.setScoreLogs(dataList);
        return vo;
    }
}
